/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common;

import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.utilities.Searchable;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.Updatable;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.utilities.WrapperUtilities;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.TypeNames;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class SResultSetMetaData
implements ResultSetMetaData {
    private List<? extends IColumn> m_columnMetaData = new ArrayList<IColumn>();
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    protected SResultSetMetaData(List<? extends IColumn> list, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, list, iLogger);
        this.m_warningListener = iWarningListener;
        this.m_columnMetaData = list;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getCatalogName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return TypeNames.getTypeClassName(typeMetadata.getType());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            return this.m_columnMetaData.size();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            long l = iColumn.getDisplaySize();
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getLabel();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return TypeUtilities.mapDataTypes(typeMetadata.getType());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getTypeName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            TypeMetadata typeMetadata = iColumn.getTypeMetadata();
            short s = typeMetadata.getType();
            if (typeMetadata.isCharacterOrBinaryType()) {
                long l = iColumn.getColumnLength();
                return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            }
            if (91 == s || 92 == s || 93 == s) {
                return (int)iColumn.getDisplaySize();
            }
            if (typeMetadata.isIntervalType()) {
                return typeMetadata.getIntervalPrecision();
            }
            return typeMetadata.getPrecision();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getScale(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getScale();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getSchemaName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTableName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getTableName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.isAutoUnique();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.isCaseSensitive();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            return this.getColumnMetadata(n).getTypeMetadata().isCurrency();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            return this.getColumnMetadata(n).isDefinitelyWritable();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int isNullable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            switch (iColumn.getNullable()) {
                case NO_NULLS: {
                    return 0;
                }
                case NULLABLE: {
                    return 1;
                }
            }
            return 2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getUpdatable() == Updatable.READ_ONLY || iColumn.getUpdatable() == Updatable.UNKNOWN;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getSearchable() != Searchable.PREDICATE_NONE;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.isSigned();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getUpdatable() == Updatable.WRITE;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    private IColumn getColumnMetadata(int n) throws SQLException {
        if (!this.isValidIndex(n)) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return this.m_columnMetaData.get(n - 1);
    }

    private TypeMetadata getTypeMetadata(int n) throws SQLException {
        IColumn iColumn = this.getColumnMetadata(n);
        return iColumn.getTypeMetadata();
    }

    private boolean isValidIndex(int n) {
        return 0 < n && this.m_columnMetaData.size() >= n;
    }
}

