/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiTsData
implements IProcResults {
    final String name;
    final TsData[] ts;

    public MultiTsData(String name, TsData[] ts) {
        this.name = name;
        this.ts = ts;
    }

    public String getName() {
        return this.name;
    }

    public TsData[] getSeries() {
        return this.ts;
    }

    @Override
    public boolean contains(String id) {
        return this.decode(id) >= 0;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        for (int i = 0; i < this.ts.length; ++i) {
            dic.put(this.encode(i), TsData.class);
        }
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (!tclass.equals(TsData.class)) {
            return null;
        }
        int i = this.decode(id);
        if (i < 0) {
            return null;
        }
        return (T)this.ts[i];
    }

    private int decode(String s) {
        if (!s.startsWith(this.name)) {
            return -1;
        }
        try {
            int i = Integer.parseInt(s.substring(this.name.length()));
            if (i <= 0 || i > this.ts.length) {
                return 0;
            }
            return i - 1;
        }
        catch (NumberFormatException err) {
            return -1;
        }
    }

    private String encode(int i) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(i + 1);
        return builder.toString();
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }
}

