/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v20;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import it.bancaditalia.oss.sdmx.api.SdmxMetaElement;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v20.CodelistParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LanguagePriorityList;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataStructureParser
implements Parser<List<DataFlowStructure>> {
    private static final String sourceClass = DataStructureParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String DATASTRUCTURE = "KeyFamily";
    static final String CODELISTS = "CodeLists";
    static final String CODELIST = "CodeList";
    static final String CODELIST2 = "codelist";
    static final String CODELISTAGENCY = "codelistAgency";
    static final String CONCEPTS = "Concepts";
    static final String CONCEPTSCHEME = "ConceptScheme";
    static final String CONCEPT = "Concept";
    static final String COMPONENTS = "Components";
    static final String NAME = "Name";
    static final String DIMENSION = "Dimension";
    static final String ATTRIBUTE = "Attribute";
    static final String TIMEDIMENSION = "TimeDimension";
    static final String PRIMARYMEASURE = "PrimaryMeasure";
    static final String CONCEPT_REF = "conceptRef";
    static final String ID = "id";
    static final String AGENCYID = "agencyID";
    static final String LOCAL_REPRESENTATION = "LocalRepresentation";
    static final String REF = "Ref";

    @Override
    public List<DataFlowStructure> parse(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        ArrayList<DataFlowStructure> arrayList = new ArrayList<DataFlowStructure>();
        Map<String, Map<String, String>> map = null;
        Map<String, String> map2 = null;
        DataFlowStructure dataFlowStructure = null;
        LocalizedText localizedText = new LocalizedText(languagePriorityList);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == CODELISTS) {
                    map = DataStructureParser.getCodelists(xMLEventReader, languagePriorityList);
                } else if (startElement.getName().getLocalPart() == CONCEPTS) {
                    map2 = DataStructureParser.getConcepts(xMLEventReader, languagePriorityList);
                } else if (startElement.getName().getLocalPart() == DATASTRUCTURE) {
                    dataFlowStructure = new DataFlowStructure();
                    localizedText.clear();
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        String string = null;
                        String string2 = null;
                        if (attribute.getName().toString().equals(ID)) {
                            string = attribute.getValue();
                            dataFlowStructure.setId(string);
                            continue;
                        }
                        if (!attribute.getName().toString().equals(AGENCYID)) continue;
                        string2 = attribute.getValue();
                        dataFlowStructure.setAgency(string2);
                    }
                } else if (startElement.getName().getLocalPart().equals(NAME)) {
                    if (dataFlowStructure != null) {
                        localizedText.setText(startElement, xMLEventReader);
                    }
                } else if (startElement.getName().getLocalPart().equals(COMPONENTS)) {
                    if (dataFlowStructure != null) {
                        DataStructureParser.setStructureDimensionsAndAttributes(dataFlowStructure, xMLEventReader, map, map2);
                    } else {
                        throw new RuntimeException("Error during Structure Parsing. Null current structure.");
                    }
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(DATASTRUCTURE)) continue;
            logger.finer("Adding data structure. " + dataFlowStructure);
            dataFlowStructure.setName(localizedText.getText());
            arrayList.add(dataFlowStructure);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    private static void setStructureDimensionsAndAttributes(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader, Map<String, Map<String, String>> map, Map<String, String> map2) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureDimensions");
        String string = dataFlowStructure.getAgency();
        SdmxMetaElement sdmxMetaElement = null;
        int n = 0;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                Object object2;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals(DIMENSION) || startElement.getName().getLocalPart().equals(ATTRIBUTE)) {
                    Object object3;
                    boolean bl = startElement.getName().getLocalPart().equals(DIMENSION);
                    if (bl) {
                        logger.finer("Got dimension");
                        sdmxMetaElement = new Dimension();
                        ((Dimension)sdmxMetaElement).setPosition(++n);
                    } else {
                        logger.finer("Got attribute");
                        sdmxMetaElement = new SdmxAttribute();
                    }
                    object2 = startElement.getAttributes();
                    object = null;
                    String string2 = null;
                    String string3 = null;
                    while (object2.hasNext()) {
                        object3 = object2.next();
                        if (object3.getName().toString().equals(CONCEPT_REF)) {
                            object = object3.getValue();
                            continue;
                        }
                        if (object3.getName().toString().equals(CODELIST2)) {
                            string2 = object3.getValue();
                            continue;
                        }
                        if (!object3.getName().toString().equals(CODELISTAGENCY)) continue;
                        string3 = object3.getValue();
                    }
                    if (object != null && !((String)object).isEmpty()) {
                        sdmxMetaElement.setId((String)object);
                        if (map2 != null) {
                            sdmxMetaElement.setName(map2.get(string + "/" + (String)object));
                        }
                    } else {
                        throw new RuntimeException("Error during Structure Parsing. Invalid id: " + (String)object);
                    }
                    if (string2 != null && !string2.isEmpty()) {
                        object3 = new Codelist(string2, string3 != null ? string3 : string, null);
                        if (map != null) {
                            Map<String, String> map3 = map.get(((Codelist)object3).getFullIdentifier());
                            ((Codelist)object3).setCodes(map3);
                        }
                        sdmxMetaElement.setCodeList((Codelist)object3);
                    } else if (bl) {
                        throw new RuntimeException("Error during Structure Parsing. Invalid CODELIST: " + string2);
                    }
                } else {
                    if (startElement.getName().getLocalPart().equals(TIMEDIMENSION)) {
                        logger.finer("Got time dimension");
                        Iterator<Attribute> iterator = startElement.getAttributes();
                        object2 = null;
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (!object.getName().toString().equals(CONCEPT_REF)) continue;
                            object2 = object.getValue();
                        }
                        if (object2 != null && !((String)object2).isEmpty()) {
                            if (dataFlowStructure != null) {
                                logger.finer("Adding time dimension: " + (String)object2);
                                dataFlowStructure.setTimeDimension((String)object2);
                                continue;
                            }
                            throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                        }
                        throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + object2);
                    }
                    if (startElement.getName().getLocalPart().equals(PRIMARYMEASURE)) {
                        logger.finer("Got primary measure");
                        Iterator<Attribute> iterator = startElement.getAttributes();
                        object2 = null;
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (!object.getName().toString().equals(CONCEPT_REF)) continue;
                            object2 = object.getValue();
                        }
                        if (object2 != null && !((String)object2).isEmpty()) {
                            if (dataFlowStructure != null) {
                                logger.finer("Adding primary measure: " + (String)object2);
                                dataFlowStructure.setMeasure((String)object2);
                                continue;
                            }
                            throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                        }
                        throw new RuntimeException("Error during Structure Parsing. Invalid primary measure: " + (String)object2);
                    }
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            if (xMLEvent.asEndElement().getName().getLocalPart().equals(DIMENSION)) {
                if (dataFlowStructure != null && sdmxMetaElement != null) {
                    logger.finer("Adding dimension: " + sdmxMetaElement);
                    dataFlowStructure.setDimension((Dimension)sdmxMetaElement);
                    continue;
                }
                throw new RuntimeException("Error during Structure Parsing. Null current structure or dimension.");
            }
            if (xMLEvent.asEndElement().getName().getLocalPart().equals(ATTRIBUTE)) {
                if (dataFlowStructure != null && sdmxMetaElement != null) {
                    logger.finer("Adding attribute: " + sdmxMetaElement);
                    dataFlowStructure.setAttribute((SdmxAttribute)sdmxMetaElement);
                    continue;
                }
                throw new RuntimeException("Error during Structure Parsing. Null current structure or dimension.");
            }
            if (!xMLEvent.asEndElement().getName().getLocalPart().equals(COMPONENTS)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureDimensions");
    }

    private static Map<String, Map<String, String>> getCodelists(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (!startElement.getName().getLocalPart().equals(CODELIST)) continue;
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = null;
                String string3 = "";
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals(AGENCYID)) continue;
                    string2 = attribute.getValue();
                }
                string3 = string2 + "/" + string;
                logger.finer("Got codelist: " + string3);
                hashMap.put(string3, CodelistParser.getCodelist(xMLEventReader, languagePriorityList));
                continue;
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CODELISTS)) continue;
            break;
        }
        return hashMap;
    }

    private static Map<String, String> getConcepts(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                Iterator<Attribute> iterator;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals(CONCEPTSCHEME)) {
                    iterator = startElement.getAttributes();
                    string = null;
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!object.getName().toString().equals(AGENCYID)) continue;
                        string = object.getValue();
                    }
                    logger.finer("Got conceptSchemeAgency: " + string);
                    continue;
                }
                if (!startElement.getName().getLocalPart().equals(CONCEPT)) continue;
                iterator = startElement.getAttributes();
                object = null;
                String string2 = null;
                String string3 = "";
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        object = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals(AGENCYID)) continue;
                    string2 = attribute.getValue();
                }
                if (string2 == null && string != null) {
                    string2 = string;
                }
                string3 = string2 + "/" + (String)object;
                logger.finer("Got concept: " + string3);
                hashMap.put(string3, DataStructureParser.getConceptName(xMLEventReader, languagePriorityList));
                continue;
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CONCEPTS)) continue;
            break;
        }
        return hashMap;
    }

    private static String getConceptName(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        LocalizedText localizedText = new LocalizedText(languagePriorityList);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() != NAME) continue;
                localizedText.setText(startElement, xMLEventReader);
                continue;
            }
            if (!xMLEvent.isEndElement() || !CONCEPT.equals(xMLEvent.asEndElement().getName().getLocalPart())) continue;
            break;
        }
        return localizedText.getText();
    }
}

