/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.memetic;

import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.algorithm.classic.SS;
import net.sf.jclec.algorithm.memetic.IOptimizer;
import net.sf.jclec.selector.BettersSelector;
import net.sf.jclec.selector.WorsesSelector;
import net.sf.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSS<I extends IIndividual>
extends SS<I> {
    private static final long serialVersionUID = 6553663167024278933L;
    protected IOptimizer<I> localOptimizer;
    protected IRandGen randgen;
    protected BettersSelector<I> bettersSelector = new BettersSelector(this);
    protected WorsesSelector<I> worsesSelector = new WorsesSelector(this);

    public IOptimizer<I> getLocalOptimizer() {
        return this.localOptimizer;
    }

    public void setLocalOptimizer(IOptimizer<I> optimizer) {
        this.localOptimizer = optimizer;
        optimizer.contextualize(this);
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        try {
            String optimizerClassname = settings.getString("local-optimizer[@type]");
            Class<?> optimizerClass = Class.forName(optimizerClassname);
            IOptimizer optimizer = (IOptimizer)optimizerClass.newInstance();
            if (optimizer instanceof IConfigure) {
                Configuration optimizerConfiguration = settings.subset("local-optimizer");
                ((IConfigure)((Object)optimizer)).configure(optimizerConfiguration);
            }
            this.setLocalOptimizer(optimizer);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.randgen = this.randGenFactory.createRandGen();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MSS) {
            MSS cother = (MSS)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.numberOfParents, cother.numberOfParents);
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void doIterate() {
        ++this.generation;
        this.doSelection();
        this.doGeneration();
        this.doOptimization();
        this.doReplacement();
        this.doUpdate();
        this.doControl();
    }

    protected void doOptimization() {
        IIndividual worstInd = (IIndividual)this.worsesSelector.select(this.bset, 1).get(0);
        for (IIndividual ind : this.cset) {
            double pBL = this.probabilityToApplyOptimizer(ind, worstInd);
            if (!(this.randgen.uniform(0.0, 1.0) < pBL)) continue;
            this.cset.add(this.localOptimizer.optimize(ind));
            this.cset.remove(ind);
        }
    }

    protected double probabilityToApplyOptimizer(I son, I worstInd) {
        if (this.evaluator.getComparator().compare(son.getFitness(), worstInd.getFitness()) == 1) {
            return 1.0;
        }
        return 0.0625;
    }
}

