/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evomodel.bigfasttree.thorney.BranchLengthLikelihoodDelegate;
import dr.evomodel.bigfasttree.thorney.MutationList;
import dr.evomodel.bigfasttree.thorney.SaddlePointExpansion;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public class PoissonBranchLengthLikelihoodDelegate
extends AbstractModel
implements BranchLengthLikelihoodDelegate {
    private final double scale;

    public PoissonBranchLengthLikelihoodDelegate(String string, double d) {
        super(string);
        this.scale = d;
    }

    @Override
    public double getLogLikelihood(MutationList mutationList, double d) {
        return SaddlePointExpansion.logPoissonProbability(d * this.scale, (int)Math.round(mutationList.getMutationCount()));
    }

    @Override
    public double getGradientWrtTime(MutationList mutationList, double d, double d2) {
        return SaddlePointExpansion.logPoissonMeanDerivative(d * d2 * this.scale, (int)Math.round(mutationList.getMutationCount())) * d2 * this.scale;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged(this, n);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

