/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmcmc;

import dr.inference.mcmcmc.MCMCMCOptions;
import java.util.ArrayList;

public class ParallelTemperingStatistics {
    private final StatisticsList[][] allStatistics;
    private final double[] temperatures;
    private static final boolean DEBUG = false;

    public ParallelTemperingStatistics(MCMCMCOptions mCMCMCOptions) {
        double[] dArray = mCMCMCOptions.getChainTemperatures();
        int n = dArray.length;
        this.temperatures = new double[n];
        System.arraycopy(dArray, 0, this.temperatures, 0, n);
        this.allStatistics = new StatisticsList[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.allStatistics[i][j] = new StatisticsList();
            }
        }
    }

    void recordStatistics(int n, int n2, int n3, int n4, double d, double d2, double d3, boolean bl) {
        if (d != this.temperatures[n3] || d2 != this.temperatures[n4]) {
            throw new IllegalArgumentException("Temperature mismatch");
        }
        this.allStatistics[n3][n4].add(new Statistics(d3, bl));
    }

    public String getReport() {
        return "Parallel tempering report";
    }

    static class StatisticsList
    extends ArrayList<Statistics> {
        StatisticsList() {
        }
    }

    static class Statistics {
        double criterion;
        boolean success;

        Statistics(double d, boolean bl) {
            this.criterion = d;
            this.success = bl;
        }
    }
}

