/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import umontreal.iro.lecuyer.gof.FDist;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class FBar {
    private static double[] F2AD = new double[103];
    private static double[] CoAD = new double[103];
    private static final double EPSILONSCAN = 1.0E-7;

    private FBar() {
    }

    public static double kolmogorovSmirnov(int n, double d) {
        return 1.0 - FDist.kolmogorovSmirnov(n, d);
    }

    public static double kolmogorovSmirnovPlus(int n, double d) {
        return 1.0 - FDist.kolmogorovSmirnovPlus(n, d);
    }

    public static double cramerVonMises(int n, double d) {
        return 1.0 - FDist.cramerVonMises(n, d);
    }

    public static double watsonU(int n, double d) {
        return 1.0 - FDist.watsonU(n, d);
    }

    public static double watsonG(int n, double d) {
        return 1.0 - FDist.watsonG(n, d);
    }

    public static double andersonDarling(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            if (d <= 0.38629436111989) {
                return 1.0;
            }
            if (d >= 1000.0) {
                return 0.0;
            }
            if (d < 8.0) {
                double d2 = 1.0 - 4.0 * Math.exp(-d - 1.0);
                return 1.0 - Math.sqrt(d2);
            }
            double d3 = 4.0 * Math.exp(-d - 1.0);
            return 0.5 * d3 * (1.0 + 0.25 * d3 * (1.0 + 0.5 * d3));
        }
        if (d > 10.0) {
            return 1.732 * Math.exp(-d) / Math.sqrt(Math.PI * d);
        }
        if (d > 5.0) {
            double d4 = Math.exp(-0.56 - 1.06 * d);
            double d5 = Math.exp(-1.03 - 1.06 * d);
            return d4 + d5 / (double)n;
        }
        if (d < 0.2) {
            return 1.0 - FDist.andersonDarling(n, d);
        }
        int n2 = (int)(1.0 + d / 0.05);
        double d6 = d / 0.05 - (double)n2;
        double d7 = (F2AD[n2 - 2] - 2.0 * F2AD[n2 - 1] + F2AD[n2]) * d6 * (d6 + 1.0) / 2.0 + (F2AD[n2] - F2AD[n2 - 1]) * d6 + F2AD[n2];
        return 1.0 - (d7 += (CoAD[n2] * (d6 + 1.0) - CoAD[n2 - 1] * d6) / (double)n);
    }

    private static double scanGlaz(int n, double d, int n2) {
        double d2;
        double d3;
        int n3;
        double d4 = n;
        double d5 = 1.0 - d;
        int n4 = (int)((double)(n + 1) * d);
        if (n4 < n2 - 1) {
            n4 = n2 - 1;
        }
        double d6 = 0.0;
        for (n3 = 1; n3 <= n4; ++n3) {
            d3 = n3;
            d6 += Math.log(d4 - d3 + 1.0) - Math.log(d3);
        }
        d6 += (double)n4 * Math.log(d) + (d4 - (double)n4) * Math.log(d5);
        d6 = d2 = Math.exp(d6);
        double d7 = n4 - n2 + 1;
        int n5 = (n4 - n2 + 1 & 1) != 0 ? -1 : 1;
        double d8 = (double)n5 * d2;
        double d9 = (double)n5 * d2 * (2.0 - d7 * d7 + d7);
        double d10 = (double)n5 * d2 * (d7 + 1.0) * (d7 + 2.0) * (6.0 + d7 * d7 - 5.0 * d7);
        n5 = (n4 - n2 + 1 & 1) != 0 ? -1 : 1;
        d7 = n4 - n2 + 1;
        double d11 = d2;
        for (n3 = n4 + 1; n3 <= n; ++n3) {
            d3 = n3;
            d7 += 1.0;
            n5 = -n5;
            if ((d11 = d11 * (d4 - d3 + 1.0) * d / (d3 * d5)) < 1.0E-7) break;
            d6 += d11;
            d8 += (double)n5 * d11;
            d9 += (double)n5 * d11 * (2.0 - d7 * d7 + d7);
            d10 += (double)n5 * d11 * (d7 + 1.0) * (d7 + 2.0) * (6.0 + d7 * d7 - 5.0 * d7);
        }
        d6 = 1.0 - d6;
        d9 /= 2.0;
        d10 /= 12.0;
        if (n2 == 3) {
            d10 = d4 * (d4 - 1.0) * d * d * Math.pow(d5, d4 - 2.0) / 8.0 + d4 * d * 2.0 * Math.pow(1.0 - 2.0 * d, d4 - 1.0) - 4.0 * Math.pow(1.0 - 2.0 * d, d4);
            if (d < 0.3333333333333333) {
                d10 += d4 * d * 2.0 * Math.pow(1.0 - 3.0 * d, d4 - 1.0) + 4.0 * Math.pow(1.0 - 3.0 * d, d4);
            }
        }
        d9 = d6 - d8 - d9;
        d10 = d9 - d10;
        double d12 = Math.log(d9) + (d4 - (double)n2 - 2.0) * Math.log(d10 / d9);
        if (d12 >= 0.0) {
            return 0.0;
        }
        if (d12 < -30.0) {
            return 1.0;
        }
        d10 = Math.exp(d12);
        return 1.0 - d10;
    }

    private static double scanWNeff(int n, double d, int n2) {
        int n3;
        double d2 = 1.0 - d;
        double d3 = 0.0;
        for (n3 = 1; n3 <= n2; ++n3) {
            d3 += Math.log(n - n3 + 1) - Math.log(n3);
        }
        double d4 = Math.exp(d3 += (double)n2 * Math.log(d) + (double)(n - n2) * Math.log(d2));
        double d5 = ((double)n2 / d - (double)n - 1.0) * d4;
        d3 = d4;
        for (n3 = n2 + 1; n3 <= n && !((d4 *= (double)(n - n3 + 1) * d / ((double)n3 * d2)) < 1.0E-7); ++n3) {
            d3 += d4;
        }
        d3 = 2.0 * d3 + d5;
        return d3;
    }

    private static double scanAsympt(int n, double d, int n2) {
        double d2 = Math.sqrt(d / (1.0 - d));
        double d3 = Math.sqrt(n);
        double d4 = (double)n2 / (d * d3) - d3;
        d3 = d2 * d4;
        d3 = d3 * d3 / 2.0;
        double d5 = 2.0 * (1.0 - NormalDist.cdf01(d2 * d4)) + d4 * d2 * Math.exp(-d3) / (d * Math.sqrt(Math.PI * 2));
        return d5;
    }

    public static double scan(int n, double d, int n2) {
        if (n < 2) {
            throw new IllegalArgumentException("Calling scan with n < 2");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Calling scan with d outside (0,1)");
        }
        if (n2 > n) {
            return 0.0;
        }
        if (n2 <= 1) {
            return 1.0;
        }
        if (n2 <= 2) {
            if ((double)(n - 1) * d >= 1.0) {
                return 1.0;
            }
            return 1.0 - Math.pow(1.0 - (double)(n - 1) * d, n);
        }
        if (d >= 0.5 && (double)n2 <= (double)(n + 1) / 2.0) {
            return 1.0;
        }
        if (d > 0.5) {
            return -1.0;
        }
        double d2 = (double)n * d;
        if ((double)n2 <= d2 + d) {
            return 1.0;
        }
        if (d2 <= 10.0) {
            return FBar.scanGlaz(n, d, n2);
        }
        double d3 = FBar.scanAsympt(n, d, n2);
        if ((d >= 0.3 && (double)n >= 50.0 || (double)n * d * d >= 250.0 && d < 0.3) && d3 <= 0.4) {
            return d3;
        }
        d3 = FBar.scanWNeff(n, d, n2);
        if (d3 <= 0.4) {
            return d3;
        }
        d3 = FBar.scanGlaz(n, d, n2);
        if (d3 > 0.4 && d3 <= 1.0) {
            return d3;
        }
        return 1.0;
    }

    static {
        FBar.F2AD[0] = 0.0;
        FBar.F2AD[1] = 1.7315E-10;
        FBar.F2AD[2] = 2.80781E-5;
        FBar.F2AD[3] = 0.00140856;
        FBar.F2AD[4] = 0.00958772;
        FBar.F2AD[5] = 0.02960552;
        FBar.F2AD[6] = 0.06185146;
        FBar.F2AD[7] = 0.10357152;
        FBar.F2AD[8] = 0.15127241;
        FBar.F2AD[9] = 0.20190317;
        FBar.F2AD[10] = 0.25318023;
        FBar.F2AD[11] = 0.30354278;
        FBar.F2AD[12] = 0.35200015;
        FBar.F2AD[13] = 0.39797537;
        FBar.F2AD[14] = 0.44117692;
        FBar.F2AD[15] = 0.48150305;
        FBar.F2AD[16] = 0.51897375;
        FBar.F2AD[17] = 0.55368396;
        FBar.F2AD[18] = 0.58577199;
        FBar.F2AD[19] = 0.61539864;
        FBar.F2AD[20] = 0.64273362;
        FBar.F2AD[21] = 0.66794694;
        FBar.F2AD[22] = 0.69120359;
        FBar.F2AD[23] = 0.7126605;
        FBar.F2AD[24] = 0.73246483;
        FBar.F2AD[25] = 0.7507533;
        FBar.F2AD[26] = 0.76765207;
        FBar.F2AD[27] = 0.78327703;
        FBar.F2AD[28] = 0.79773426;
        FBar.F2AD[29] = 0.81112067;
        FBar.F2AD[30] = 0.82352466;
        FBar.F2AD[31] = 0.83502676;
        FBar.F2AD[32] = 0.84570037;
        FBar.F2AD[33] = 0.85561231;
        FBar.F2AD[34] = 0.86482346;
        FBar.F2AD[35] = 0.87338931;
        FBar.F2AD[36] = 0.88136046;
        FBar.F2AD[37] = 0.88878306;
        FBar.F2AD[38] = 0.89569925;
        FBar.F2AD[39] = 0.90214757;
        FBar.F2AD[40] = 0.9081653;
        FBar.F2AD[41] = 0.91378043;
        FBar.F2AD[42] = 0.91902284;
        FBar.F2AD[43] = 0.92392345;
        FBar.F2AD[44] = 0.92850516;
        FBar.F2AD[45] = 0.93279084;
        FBar.F2AD[46] = 0.93680149;
        FBar.F2AD[47] = 0.94055647;
        FBar.F2AD[48] = 0.9440736;
        FBar.F2AD[49] = 0.94736933;
        FBar.F2AD[50] = 0.95045883;
        FBar.F2AD[51] = 0.95335611;
        FBar.F2AD[52] = 0.95607414;
        FBar.F2AD[53] = 0.9586249;
        FBar.F2AD[54] = 0.96101951;
        FBar.F2AD[55] = 0.96326825;
        FBar.F2AD[56] = 0.96538067;
        FBar.F2AD[57] = 0.96736563;
        FBar.F2AD[58] = 0.96923135;
        FBar.F2AD[59] = 0.97098548;
        FBar.F2AD[60] = 0.97263514;
        FBar.F2AD[61] = 0.97418694;
        FBar.F2AD[62] = 0.97564704;
        FBar.F2AD[63] = 0.97702119;
        FBar.F2AD[64] = 0.97831473;
        FBar.F2AD[65] = 0.97953267;
        FBar.F2AD[66] = 0.98067966;
        FBar.F2AD[67] = 0.98176005;
        FBar.F2AD[68] = 0.9827779;
        FBar.F2AD[69] = 0.98373702;
        FBar.F2AD[70] = 0.98464096;
        FBar.F2AD[71] = 0.98549304;
        FBar.F2AD[72] = 0.98629637;
        FBar.F2AD[73] = 0.98705386;
        FBar.F2AD[74] = 0.98776824;
        FBar.F2AD[75] = 0.98844206;
        FBar.F2AD[76] = 0.98907773;
        FBar.F2AD[77] = 0.98967747;
        FBar.F2AD[78] = 0.99024341;
        FBar.F2AD[79] = 0.99077752;
        FBar.F2AD[80] = 0.99128164;
        FBar.F2AD[81] = 0.99175753;
        FBar.F2AD[82] = 0.99220682;
        FBar.F2AD[83] = 0.99263105;
        FBar.F2AD[84] = 0.99303165;
        FBar.F2AD[85] = 0.99340998;
        FBar.F2AD[86] = 0.99376733;
        FBar.F2AD[87] = 0.99410488;
        FBar.F2AD[88] = 0.99442377;
        FBar.F2AD[89] = 0.99472506;
        FBar.F2AD[90] = 0.99500974;
        FBar.F2AD[91] = 0.99527876;
        FBar.F2AD[92] = 0.995533;
        FBar.F2AD[93] = 0.99577329;
        FBar.F2AD[94] = 0.99600042;
        FBar.F2AD[95] = 0.99621513;
        FBar.F2AD[96] = 0.9964181;
        FBar.F2AD[97] = 0.99661;
        FBar.F2AD[98] = 0.99679145;
        FBar.F2AD[99] = 0.99696303;
        FBar.F2AD[100] = 0.99712528;
        FBar.F2AD[101] = 0.99727872;
        FBar.F2AD[102] = 0.99742384;
        FBar.CoAD[0] = 0.0;
        FBar.CoAD[1] = 0.0;
        FBar.CoAD[2] = 0.0;
        FBar.CoAD[3] = 0.0;
        FBar.CoAD[4] = 0.0;
        FBar.CoAD[5] = -0.00187;
        FBar.CoAD[6] = 0.00898;
        FBar.CoAD[7] = 0.0209;
        FBar.CoAD[8] = 0.03087;
        FBar.CoAD[9] = 0.0377;
        FBar.CoAD[10] = 0.0414;
        FBar.CoAD[11] = 0.04386;
        FBar.CoAD[12] = 0.043;
        FBar.CoAD[13] = 0.0419;
        FBar.CoAD[14] = 0.0403;
        FBar.CoAD[15] = 0.038;
        FBar.CoAD[16] = 0.0354804;
        FBar.CoAD[17] = 0.032;
        FBar.CoAD[18] = 0.0293;
        FBar.CoAD[19] = 0.0261949;
        FBar.CoAD[20] = 0.0228;
        FBar.CoAD[21] = 0.0192;
        FBar.CoAD[22] = 0.0159865;
        FBar.CoAD[23] = 0.0129;
        FBar.CoAD[24] = 0.0107;
        FBar.CoAD[25] = 0.0082464;
        FBar.CoAD[26] = 0.00611;
        FBar.CoAD[27] = 0.00363;
        FBar.CoAD[28] = 0.00132272;
        FBar.CoAD[29] = -5.87E-4;
        FBar.CoAD[30] = -0.00275;
        FBar.CoAD[31] = -0.00395248;
        FBar.CoAD[32] = -0.00534;
        FBar.CoAD[33] = -0.006892;
        FBar.CoAD[34] = -0.00810208;
        FBar.CoAD[35] = -0.00893;
        FBar.CoAD[36] = -0.009552;
        FBar.CoAD[37] = -0.0104605;
        FBar.CoAD[38] = -0.0112;
        FBar.CoAD[39] = -0.01175;
        FBar.CoAD[40] = -0.0120216;
        FBar.CoAD[41] = -0.0124;
        FBar.CoAD[42] = -0.01253;
        FBar.CoAD[43] = -0.0127076;
        FBar.CoAD[44] = -0.0129;
        FBar.CoAD[45] = -0.01267;
        FBar.CoAD[46] = -0.0122015;
        FBar.CoAD[47] = -0.0122;
        FBar.CoAD[48] = -0.01186;
        FBar.CoAD[49] = -0.0117218;
        FBar.CoAD[50] = -0.0114;
        FBar.CoAD[51] = -0.01113;
        FBar.CoAD[52] = -0.0108459;
        FBar.CoAD[53] = -0.0104;
        FBar.CoAD[54] = -0.00993;
        FBar.CoAD[55] = -0.0095252;
        FBar.CoAD[56] = -0.00924;
        FBar.CoAD[57] = -0.00916;
        FBar.CoAD[58] = -0.0088004;
        FBar.CoAD[59] = -0.00863;
        FBar.CoAD[60] = -0.008336;
        FBar.CoAD[61] = -0.00810512;
        FBar.CoAD[62] = -0.00794;
        FBar.CoAD[63] = -0.00771;
        FBar.CoAD[64] = -0.00755064;
        FBar.CoAD[65] = -0.00725;
        FBar.CoAD[66] = -0.00711;
        FBar.CoAD[67] = -0.006834;
        FBar.CoAD[68] = -0.0065;
        FBar.CoAD[69] = -0.00628;
        FBar.CoAD[70] = -0.00611008;
        FBar.CoAD[71] = -0.00586;
        FBar.CoAD[72] = -0.005673;
        FBar.CoAD[73] = -0.00535008;
        FBar.CoAD[74] = -0.00511;
        FBar.CoAD[75] = -0.004786;
        FBar.CoAD[76] = -0.00459144;
        FBar.CoAD[77] = -0.00438;
        FBar.CoAD[78] = -0.00415;
        FBar.CoAD[79] = -0.00407696;
        FBar.CoAD[80] = -0.00393;
        FBar.CoAD[81] = -0.00383;
        FBar.CoAD[82] = -0.00374656;
        FBar.CoAD[83] = -0.00349;
        FBar.CoAD[84] = -0.00333;
        FBar.CoAD[85] = -0.00320064;
        FBar.CoAD[86] = -0.00309;
        FBar.CoAD[87] = -0.00293;
        FBar.CoAD[88] = -0.00278136;
        FBar.CoAD[89] = -0.00272;
        FBar.CoAD[90] = -0.00266;
        FBar.CoAD[91] = -0.00256208;
        FBar.CoAD[92] = -0.00243;
        FBar.CoAD[93] = -0.00228;
        FBar.CoAD[94] = -0.00213536;
        FBar.CoAD[95] = -0.002083;
        FBar.CoAD[96] = -0.00194;
        FBar.CoAD[97] = -0.00182;
        FBar.CoAD[98] = -0.00177;
        FBar.CoAD[99] = -0.00172;
        FBar.CoAD[100] = -0.00171104;
        FBar.CoAD[101] = -0.001741;
        FBar.CoAD[102] = -0.0016;
    }
}

