/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.UnknownEncodingException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.DC_11;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class ContentAssembler
extends AssemblerBase
implements Assembler {
    static final String preamble = "@prefix rdf: <" + RDF.getURI() + "> ." + "\n@prefix rdfs: <" + RDFS.getURI() + "> ." + "\n@prefix owl: <" + OWL.getURI() + "> ." + "\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> ." + "\n@prefix dc: <" + DC_11.getURI() + "> .";

    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.Content);
        return new Content(ContentAssembler.loadContent(new ArrayList(), this, root));
    }

    public static List loadContent(List contents, Assembler a, Resource root) {
        ContentAssembler.addLiteralContent(contents, root);
        ContentAssembler.addQuotedContent(contents, root);
        ContentAssembler.addExternalContents(contents, root);
        ContentAssembler.addIndirectContent(contents, a, root);
        return contents;
    }

    private static void addIndirectContent(List contents, Assembler a, Resource root) {
        StmtIterator it = root.listProperties(JA.content);
        while (it.hasNext()) {
            contents.add(a.open(ContentAssembler.getResource(it.nextStatement())));
        }
    }

    protected static void addExternalContents(List contents, Resource root) {
        StmtIterator it = root.listProperties(JA.externalContent);
        while (it.hasNext()) {
            contents.add(ContentAssembler.objectAsContent(it.nextStatement()));
        }
    }

    private static void addQuotedContent(List contents, Resource root) {
        StmtIterator it = root.listProperties(JA.quotedContent);
        while (it.hasNext()) {
            Resource q = ContentAssembler.getResource(it.nextStatement());
            Model m = ResourceUtils.reachableClosure(q);
            contents.add(ContentAssembler.newModelContent(m));
        }
    }

    protected static void addLiteralContent(List contents, Resource root) {
        String encoding = ContentAssembler.getEncoding(root);
        StmtIterator it = root.listProperties(JA.literalContent);
        while (it.hasNext()) {
            String s = ContentAssembler.getString(it.nextStatement());
            Model model = ContentAssembler.parseAs(root, encoding, s);
            contents.add(ContentAssembler.newModelContent(model));
        }
    }

    private static Model parseAs(Resource root, String encoding, String lexicalForm) {
        String enc;
        String string = enc = encoding == null ? ContentAssembler.guessFrom(lexicalForm) : encoding;
        if (enc.equals("N3")) {
            return ContentAssembler.parseAsN3(lexicalForm);
        }
        if (enc.equals("RDF/XML")) {
            return ContentAssembler.parseAsXML(lexicalForm);
        }
        throw new UnknownEncodingException(root, encoding);
    }

    private static Model parseAsXML(String lexicalForm) {
        String pre = "<?xml version='1.0'?><rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' xmlns:xsd='http://www.w3.org/2001/XMLSchema#' xmlns:owl='http://www.w3.org/2002/07/owl#' xmlns:dc='http://purl.org/dc/elements/1.1/'>";
        String post = "</rdf:RDF>";
        StringReader r = new StringReader(pre + lexicalForm + post);
        return ModelFactory.createDefaultModel().read(r, "", "RDF/XML");
    }

    private static String guessFrom(String lexicalForm) {
        return "N3";
    }

    private static String getEncoding(Resource root) {
        Literal L = ContentAssembler.getUniqueLiteral(root, JA.contentEncoding);
        return L == null ? null : L.getLexicalForm();
    }

    protected static Content newModelContent(final Model m) {
        return new Content(){

            public Model fill(Model x) {
                x.setNsPrefixes(m);
                return x.add(m);
            }
        };
    }

    protected static Content objectAsContent(Statement s) {
        Resource external = ContentAssembler.getResource(s);
        Model m = FileManager.get().loadModel(external.getURI());
        return ContentAssembler.newModelContent(m);
    }

    protected static Model parseAsN3(String value) {
        Model result = ModelFactory.createDefaultModel();
        StringReader r = new StringReader(preamble + "\n" + value);
        result.read(r, "", "N3");
        return result;
    }
}

