/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.falco;

import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.FilteredMutator;
import net.sourceforge.jclec.base.FilteredRecombinator;
import net.sourceforge.jclec.problem.classification.Classifier;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.IClassifier;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.falco.FalcoEvaluator;
import net.sourceforge.jclec.problem.classification.falco.FalcoSyntaxTreeSpecies;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.AbstractRandGenFactory;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.random.RanecuFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class FalcoAlgorithm
extends PopulationAlgorithm {
    private static final long serialVersionUID = -8711970425735016406L;
    protected ISelector parentsSelector;
    protected FilteredRecombinator recombinator;
    protected FilteredMutator mutator;
    protected IClassifier classifier = new Classifier();
    double copyProb;
    private IDataset trainSet;
    private IDataset testSet;
    private IMetadata trainMetadata;
    private IMetadata testMetadata;
    protected int classesNumber;
    protected int execution = 0;
    protected IRandGen randgen;
    protected BettersSelector bettersSelector = new BettersSelector(this);

    public ISelector getParentsSelector() {
        return this.parentsSelector;
    }

    public void setParentsSelector(ISelector parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public FilteredRecombinator getRecombinator() {
        return this.recombinator;
    }

    public void setRecombinator(IRecombinator recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public FilteredMutator getMutator() {
        return this.mutator;
    }

    public void setMutator(IMutator mutator) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setDecorated(mutator);
    }

    public IClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(IClassifier classifier) {
        this.classifier = classifier;
    }

    public double getCopyProb() {
        return this.copyProb;
    }

    public void setCopyProb(double copyProb) {
        this.copyProb = copyProb;
    }

    public IDataset getTrainSet() {
        return this.trainSet;
    }

    public void setTrainSet(IDataset train) {
        this.trainSet = train;
    }

    public IDataset getTestSet() {
        return this.testSet;
    }

    public void setTestSet(IDataset test) {
        this.testSet = test;
    }

    public IMetadata getTrainMetadata() {
        return this.trainMetadata;
    }

    public void setTrainMetadata(IMetadata train) {
        this.trainMetadata = train;
    }

    public IMetadata getTestMetadata() {
        return this.testMetadata;
    }

    public void setTestMetadata(IMetadata test) {
        this.testMetadata = test;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        this.setDatasetSettings(settings);
        int maxDerivSize = settings.getInt("max-deriv-size");
        ((FalcoSyntaxTreeSpecies)this.getSpecies()).setFalcoGrammar();
        ((FalcoSyntaxTreeSpecies)this.getSpecies()).setMaxDerivSize(maxDerivSize);
        RanecuFactory randGenFactory = new RanecuFactory();
        int seed = ((AbstractRandGenFactory)this.getRandGenFactory()).getSeed();
        randGenFactory.setSeed(seed);
        ((FalcoEvaluator)this.evaluator).setRandGen(randGenFactory.createRandGen());
        ((FalcoEvaluator)this.evaluator).setMaxDerivSize(maxDerivSize);
        this.setParentsSelectorSettings(settings);
        this.setRecombinatorSettings(settings);
        this.setMutatorSettings(settings);
        double copyProb = settings.getDouble("copy-prob", 0.1);
        this.setCopyProb(copyProb);
    }

    private void setMutatorSettings(Configuration settings) {
        try {
            String mutatorClassname = settings.getString("mutator[@type]");
            Class<?> mutatorClass = Class.forName(mutatorClassname);
            IMutator mutator = (IMutator)mutatorClass.newInstance();
            if (mutator instanceof IConfigure) {
                Configuration mutatorConfiguration = settings.subset("mutator");
                ((IConfigure)((Object)mutator)).configure(mutatorConfiguration);
            }
            this.setMutator(mutator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        double mutProb = settings.getDouble("mutator[@mut-prob]", 0.05);
        this.setMutationProb(mutProb);
    }

    private void setRecombinatorSettings(Configuration settings) {
        try {
            String recombinatorClassname = settings.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = settings.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        double recProb = settings.getDouble("recombinator[@rec-prob]", 0.7);
        this.setRecombinationProb(recProb);
    }

    private void setParentsSelectorSettings(Configuration settings) {
        try {
            String parentsSelectorClassname = settings.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = settings.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
    }

    private void setDatasetSettings(Configuration settings) {
        try {
            String datasetClassname = settings.getString("dataset[@type]");
            Class<?> datasetClass = Class.forName(datasetClassname);
            this.setTrainSet((IDataset)datasetClass.newInstance());
            Configuration datasetSettings = settings.subset("dataset.train-data");
            this.getTrainSet().configure(datasetSettings);
            this.setTestSet((IDataset)datasetClass.newInstance());
            datasetSettings = settings.subset("dataset.test-data");
            this.getTestSet().configure(datasetSettings);
            this.getTrainSet().open();
            this.setTrainMetadata(this.getTrainSet().getMetadata());
            this.getTrainSet().loadInstances();
            this.getTrainSet().close();
            this.getTestSet().open();
            this.setTestMetadata(this.getTestSet().getMetadata());
            this.getTestSet().loadInstances();
            this.getTestSet().close();
            String attributeClass = settings.getString("dataset.attribute-class-name");
            if (attributeClass != null) {
                int attributeClassIndex = this.getTrainMetadata().getIndex(attributeClass);
                this.getTrainMetadata().setClassIndex(attributeClassIndex);
                this.getTestMetadata().setClassIndex(attributeClassIndex);
            } else {
                this.getTrainMetadata().setClassIndex(this.trainMetadata.numberOfAttributes() - 1);
                this.getTestMetadata().setClassIndex(this.testMetadata.numberOfAttributes() - 1);
            }
            ((Classifier)this.classifier).setDefaultClass(0.0);
            ((FalcoSyntaxTreeSpecies)this.getSpecies()).setMetadata(this.getTrainMetadata());
            CategoricalAttribute catAttr = (CategoricalAttribute)this.getTrainMetadata().getAttribute(this.getTrainMetadata().getClassIndex());
            this.setClassesNumber(catAttr.getCategories().size());
            ((FalcoEvaluator)this.evaluator).setDataset(this.getTrainSet());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (DatasetException e) {
            e.printStackTrace();
        }
    }

    private void setClassesNumber(int size) {
        this.classesNumber = size;
    }

    private void setRecombinationProb(double recProb) {
        this.recombinator.setRecProb(recProb);
    }

    private void setMutationProb(double mutProb) {
        this.mutator.setMutProb(mutProb);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FalcoAlgorithm) {
            FalcoAlgorithm cother = (FalcoAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset, this.bset.size());
    }

    @Override
    protected void doGeneration() {
        this.rset = this.recombinator.recombine(this.pset);
        this.rset.addAll(this.recombinator.getSterile());
        List<IIndividual> mset = this.mutator.mutate(this.rset);
        mset.addAll(this.mutator.getSterile());
        this.evaluator.evaluate(mset);
        this.cset = mset;
    }

    @Override
    protected void doReplacement() {
        this.rset = this.bset;
    }

    @Override
    protected void doUpdate() {
        int numIndividuals = this.bset.size();
        for (IIndividual ind : this.bset) {
            if (!this.getRandGenFactory().createRandGen().coin(this.copyProb)) continue;
            this.cset.add(ind);
        }
        this.bset = this.cset.size() > numIndividuals ? this.bettersSelector.select(this.cset, numIndividuals) : this.cset;
        int currentNumber = this.bset.size();
        if (currentNumber < numIndividuals) {
            List<IIndividual> bests = this.bettersSelector.select(this.bset, this.bset.size());
            int i = currentNumber;
            while (i < numIndividuals) {
                this.bset.add(bests.remove(0));
                ++i;
            }
        }
        this.rset = null;
        this.pset = null;
        this.cset = null;
    }

    @Override
    protected void doControl() {
        if (this.generation >= this.maxOfGenerations) {
            ++this.execution;
            IIndividual best = this.bettersSelector.select(this.bset, 1).get(0);
            IClassificationRule phenotype = ((Individual)best).getPhenotype();
            phenotype.setConsequent(this.execution - 1);
            ((Classifier)this.classifier).addClassificationRule(phenotype);
            if (this.execution == this.classesNumber) {
                this.state = 3;
                return;
            }
            ((FalcoEvaluator)this.evaluator).setClassifiedClass(this.execution);
            this.generation = 0;
            this.doInit();
        }
        for (IIndividual individual : this.bset) {
            if (!individual.getFitness().isAcceptable()) continue;
            ++this.execution;
            IIndividual best = this.bettersSelector.select(this.bset, 1).get(0);
            IClassificationRule phenotype = ((Individual)best).getPhenotype();
            if (this.execution == this.classesNumber) {
                phenotype.setConsequent(this.execution - 1);
                ((Classifier)this.classifier).addClassificationRule(phenotype);
                this.state = 3;
                return;
            }
            ((Classifier)this.classifier).addClassificationRule(phenotype);
            ((FalcoEvaluator)this.evaluator).setClassifiedClass(this.execution);
            this.doInit();
            this.generation = 0;
        }
    }
}

