/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdistmulti.BiNormalDist;

public class BiNormalGenzDist
extends BiNormalDist {
    private static final double[][] W = new double[][]{{0.1713244923791705, 0.3607615730481384, 0.4679139345726904}, {0.04717533638651177, 0.1069393259953183, 0.1600783285433464, 0.2031674267230659, 0.2334925365383547, 0.2491470458134029}, {0.01761400713915212, 0.04060142980038694, 0.06267204833410905, 0.08327674157670475, 0.1019301198172404, 0.1181945319615184, 0.1316886384491766, 0.1420961093183821, 0.1491729864726037, 0.1527533871307259}};
    private static final double[][] X = new double[][]{{0.9324695142031522, 0.6612093864662647, 0.238619186083197}, {0.9815606342467191, 0.904117256370475, 0.769902674194305, 0.5873179542866171, 0.3678314989981802, 0.1252334085114692}, {0.9931285991850949, 0.9639719272779138, 0.912234428251326, 0.8391169718222188, 0.7463319064601508, 0.636053680726515, 0.5108670019508271, 0.3737060887154196, 0.2277858511416451, 0.07652652113349732}};

    public BiNormalGenzDist(double rho) {
        super(rho);
    }

    public BiNormalGenzDist(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        super(mu1, sigma1, mu2, sigma2, rho);
    }

    public static double cdf(double x, double y, double rho) {
        int lg;
        int ng;
        double bvn = BiNormalGenzDist.specialCDF(x, y, rho, 40.0);
        if (bvn >= 0.0) {
            return bvn;
        }
        double TWOPI = Math.PI * 2;
        double sqrt2pi = 2.5066282746310007;
        if (Math.abs(rho) < 0.3) {
            ng = 0;
            lg = 3;
        } else if (Math.abs(rho) < 0.75) {
            ng = 1;
            lg = 6;
        } else {
            ng = 2;
            lg = 10;
        }
        double h = -x;
        double k = -y;
        double hk = h * k;
        bvn = 0.0;
        if (Math.abs(rho) < 0.925) {
            double hs = (h * h + k * k) / 2.0;
            double asr = Math.asin(rho);
            for (int i = 0; i < lg; ++i) {
                double sn = Math.sin(asr * (1.0 - X[ng][i]) / 2.0);
                bvn += W[ng][i] * Math.exp((sn * hk - hs) / (1.0 - sn * sn));
                sn = Math.sin(asr * (1.0 + X[ng][i]) / 2.0);
                bvn += W[ng][i] * Math.exp((sn * hk - hs) / (1.0 - sn * sn));
            }
            bvn = bvn * asr / (Math.PI * 4) + NormalDist.cdf01(-h) * NormalDist.cdf01(-k);
        } else {
            double xs;
            if (rho < 0.0) {
                k = -k;
                hk = -hk;
            }
            if (Math.abs(rho) < 1.0) {
                double sp;
                double as = (1.0 - rho) * (1.0 + rho);
                double a = Math.sqrt(as);
                double bs = (h - k) * (h - k);
                double c = (4.0 - hk) / 8.0;
                double d = (12.0 - hk) / 16.0;
                double asr = -(bs / as + hk) / 2.0;
                if (asr > -100.0) {
                    bvn = a * Math.exp(asr) * (1.0 - c * (bs - as) * (1.0 - d * bs / 5.0) / 3.0 + c * d * as * as / 5.0);
                }
                if (-hk < 100.0) {
                    double b = Math.sqrt(bs);
                    sp = 2.5066282746310007 * NormalDist.cdf01(-b / a);
                    bvn -= Math.exp(-hk / 2.0) * sp * b * (1.0 - c * bs * (1.0 - d * bs / 5.0) / 3.0);
                }
                a /= 2.0;
                for (int i = 0; i < lg; ++i) {
                    for (int is = -1; is <= 1; is += 2) {
                        xs = a * ((double)is * X[ng][i] + 1.0);
                        xs *= xs;
                        double rs = Math.sqrt(1.0 - xs);
                        asr = -(bs / xs + hk) / 2.0;
                        if (!(asr > -100.0)) continue;
                        sp = 1.0 + c * xs * (1.0 + d * xs);
                        double ep = Math.exp(-hk * (1.0 - rs) / (2.0 * (1.0 + rs))) / rs;
                        bvn += a * W[ng][i] * Math.exp(asr) * (ep - sp);
                    }
                }
                bvn = -bvn / (Math.PI * 2);
            }
            if (rho > 0.0) {
                if (k > h) {
                    h = k;
                }
                bvn += NormalDist.cdf01(-h);
            }
            if (rho < 0.0) {
                xs = NormalDist.cdf01(-h) - NormalDist.cdf01(-k);
                if (xs < 0.0) {
                    xs = 0.0;
                }
                bvn = -bvn + xs;
            }
        }
        if (bvn <= 0.0) {
            return 0.0;
        }
        if (bvn >= 1.0) {
            return 1.0;
        }
        return bvn;
    }

    public static double cdf(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double Z = (x - mu1) / sigma1;
        double T = (y - mu2) / sigma2;
        return BiNormalGenzDist.cdf(Z, T, rho);
    }

    public double cdf(double x, double y) {
        return BiNormalGenzDist.cdf((x - this.mu1) / this.sigma1, (y - this.mu2) / this.sigma2, this.rho);
    }

    public double barF(double x, double y) {
        return BiNormalGenzDist.barF((x - this.mu1) / this.sigma1, (y - this.mu2) / this.sigma2, this.rho);
    }

    public static double barF(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double Z = (x - mu1) / sigma1;
        double T = (y - mu2) / sigma2;
        return BiNormalGenzDist.barF(Z, T, rho);
    }

    public static double barF(double x, double y, double rho) {
        return BiNormalGenzDist.cdf(-x, -y, rho);
    }
}

