/*
 * Decompiled with CFR 0.152.
 */
package io.github.crew102.rapidrake.opennlpUtils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;

public class SentDetector {
    private String sentDectModelUrl;
    private InputStream sentDectStream;

    public SentDetector(String sentDectModelUrl) {
        this.sentDectModelUrl = sentDectModelUrl;
    }

    public SentDetector(InputStream sentDectStream) {
        this.sentDectStream = sentDectStream;
    }

    public SentenceDetectorME getSentDetector() throws IOException {
        InputStream inStream = this.sentDectStream;
        SentenceModel modelIn = null;
        try {
            if (this.sentDectModelUrl != null) {
                inStream = new FileInputStream(this.sentDectModelUrl);
            }
            modelIn = new SentenceModel(inStream);
        }
        catch (IOException ex) {
            throw new IOException("Couldn't find sentence detector model based on URL", ex);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ex2) {
                    throw new IOException(ex2);
                }
            }
        }
        return new SentenceDetectorME(modelIn);
    }
}

