/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.ReactionSceneGenerator;

public class ProductsBoxGenerator
implements IGenerator<IReaction> {
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        if (!((Boolean)((ReactionSceneGenerator.ShowReactionBoxes)model.getParameter(ReactionSceneGenerator.ShowReactionBoxes.class)).getValue()).booleanValue()) {
            return null;
        }
        if (reaction.getProductCount() == 0) {
            return new ElementGroup();
        }
        double distance = (Double)((BasicSceneGenerator.BondLength)model.getParameter(BasicSceneGenerator.BondLength.class)).getValue() / (Double)((BasicSceneGenerator.Scale)model.getParameter(BasicSceneGenerator.Scale.class)).getValue() / 2.0;
        Rectangle2D totalBounds = null;
        for (IAtomContainer molecule : reaction.getProducts().atomContainers()) {
            Rectangle2D bounds = BoundsCalculator.calculateBounds((IAtomContainer)molecule);
            if (totalBounds == null) {
                totalBounds = bounds;
                continue;
            }
            totalBounds = totalBounds.createUnion(bounds);
        }
        if (totalBounds == null) {
            return null;
        }
        ElementGroup diagram = new ElementGroup();
        Color foregroundColor = (Color)((BasicSceneGenerator.ForegroundColor)model.getParameter(BasicSceneGenerator.ForegroundColor.class)).getValue();
        diagram.add((IRenderingElement)new RectangleElement(totalBounds.getMinX() - distance, totalBounds.getMinY() - distance, totalBounds.getMaxX() + distance, totalBounds.getMaxY() + distance, foregroundColor));
        diagram.add((IRenderingElement)new TextElement((totalBounds.getMinX() + totalBounds.getMaxX()) / 2.0, totalBounds.getMinY() - distance, "Products", foregroundColor));
        return diagram;
    }

    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

