/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TransformableTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.continuous.AncestralTaxonInTree;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AncestralTraitTreeModel
extends AbstractModel
implements MutableTreeModel,
TransformableTree,
Citable {
    private static final boolean DEBUG = false;
    private final int ancestorCount;
    private final int treeExternalCount;
    private final int treeInternalCount;
    private final int externalCount;
    private final int internalCount;
    private ShadowNode[] nodes;
    private ShadowNode[] storedNodes;
    private ShadowNode root;
    private int storedRootNumber;
    private Map<Parameter, NodeRef> heightParameterBoundMap;
    private static final boolean FIX_BRANCH_LENGTH = false;
    private final MutableTreeModel treeModel;
    private final List<AncestralTaxonInTree> ancestors;
    private static final boolean NEW_APPROACH2 = false;
    private final Map<BitSet, AncestralTaxonInTree> clampList = new HashMap<BitSet, AncestralTaxonInTree>();
    private final Map<Integer, List<AncestralTaxonInTree>> nodeToClampMap = new HashMap<Integer, List<AncestralTaxonInTree>>();
    private Set<Integer> ancestralPathNodeNumbers = new HashSet<Integer>();
    private Set<Integer> savedAncestralPathNodeNumbers = new HashSet<Integer>();
    private boolean hasAncestralPathTaxa = false;
    private boolean validShadowTree = false;
    private boolean savedValidShadowTree;

    @Override
    public NodeRef getOriginalNode(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        ShadowNode shadowNode = (ShadowNode)nodeRef;
        return shadowNode.getOriginalNode();
    }

    @Override
    public NodeRef getTransformedNode(NodeRef nodeRef) {
        return new TransformableTree.BasicNode(this.mapOriginalToShadowNumber(nodeRef.getNumber()));
    }

    public void addTipHeightBound(NodeRef nodeRef) {
        Parameter parameter = ((DefaultTreeModel.Node)nodeRef).getHeightParameter();
        parameter.addBounds(new NodeHeightBoundsWithAncestor(parameter));
        if (this.heightParameterBoundMap == null) {
            this.heightParameterBoundMap = new HashMap<Parameter, NodeRef>();
        }
        this.heightParameterBoundMap.put(parameter, nodeRef);
    }

    public ShadowNode getNodeOfHeightParameter(Parameter parameter) {
        NodeRef nodeRef = this.heightParameterBoundMap.get(parameter);
        if (nodeRef == null) {
            throw new IllegalArgumentException("Unknown height parameter");
        }
        return this.nodes[this.mapOriginalToShadowNumber(nodeRef.getNumber())];
    }

    public static String toString(ShadowNode[] shadowNodeArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ShadowNode shadowNode : shadowNodeArray) {
            if (shadowNode != null) {
                stringBuilder.append(shadowNode).append("\n");
                continue;
            }
            stringBuilder.append("null\n");
        }
        stringBuilder.append("root = ").append(n);
        return stringBuilder.toString();
    }

    public AncestralTraitTreeModel(String string, MutableTreeModel mutableTreeModel, List<AncestralTaxonInTree> list) {
        super(string);
        this.treeModel = mutableTreeModel;
        this.ancestors = list;
        this.ancestorCount = list.size();
        this.treeExternalCount = this.treeModel.getExternalNodeCount();
        this.treeInternalCount = this.treeModel.getInternalNodeCount();
        this.externalCount = this.treeExternalCount + this.ancestorCount;
        this.internalCount = this.treeInternalCount + this.ancestorCount;
        this.addModel(mutableTreeModel);
        int n = 0;
        for (AncestralTaxonInTree ancestralTaxonInTree : list) {
            this.addRestrictedPartials(ancestralTaxonInTree, n);
            ++n;
        }
        this.nodes = new ShadowNode[this.externalCount + this.internalCount];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new ShadowNode();
        }
    }

    @Override
    public Tree getOriginalTree() {
        return this.treeModel;
    }

    private void checkShadowTree() {
        if (!this.validShadowTree) {
            this.buildShadowTree();
            this.validShadowTree = true;
        }
    }

    private void buildShadowTree() {
        this.setupClamps();
        for (ShadowNode shadowNode : this.nodes) {
            shadowNode.setUnused();
        }
        this.root = this.buildRecursivelyShadowTree(this.treeModel.getRoot(), null);
    }

    private void storeNode(ShadowNode shadowNode) {
        this.nodes[shadowNode.getNumber()] = shadowNode;
    }

    private static void sortByTime(List<AncestralTaxonInTree> list) {
        list.sort((ancestralTaxonInTree, ancestralTaxonInTree2) -> -Double.compare(ancestralTaxonInTree.getHeight(), ancestralTaxonInTree2.getHeight()));
    }

    private ShadowNode buildRecursivelyShadowTree(NodeRef nodeRef, ShadowNode shadowNode) {
        List<AncestralTaxonInTree> list;
        int n = nodeRef.getNumber();
        int n2 = this.mapOriginalToShadowNumber(n);
        ShadowNode shadowNode2 = new ShadowNode(n2, nodeRef, null);
        shadowNode2.parent = shadowNode;
        this.storeNode(shadowNode2);
        ShadowNode shadowNode3 = shadowNode2;
        ShadowNode shadowNode4 = shadowNode2;
        if (this.nodeToClampMap.containsKey(nodeRef.getNumber())) {
            list = this.nodeToClampMap.get(nodeRef.getNumber());
            if (list.size() > 1) {
                AncestralTraitTreeModel.sortByTime(list);
            }
            for (AncestralTaxonInTree ancestralTaxonInTree : list) {
                int n3 = this.treeExternalCount + ancestralTaxonInTree.getIndex();
                ShadowNode shadowNode5 = new ShadowNode(n3, null, ancestralTaxonInTree);
                ShadowNode shadowNode6 = new ShadowNode(this.externalCount + this.treeInternalCount + ancestralTaxonInTree.getIndex(), null, ancestralTaxonInTree);
                if (ancestralTaxonInTree.getPathChildNumber() == 0) {
                    shadowNode3.child0 = shadowNode6;
                    shadowNode6.parent = shadowNode3;
                    shadowNode6.child1 = shadowNode5;
                    shadowNode5.parent = shadowNode6;
                    shadowNode3 = shadowNode6;
                } else {
                    shadowNode4.child1 = shadowNode6;
                    shadowNode6.parent = shadowNode4;
                    shadowNode6.child0 = shadowNode5;
                    shadowNode5.parent = shadowNode6;
                    shadowNode4 = shadowNode6;
                }
                this.storeNode(shadowNode5);
                this.storeNode(shadowNode6);
            }
        }
        if (!this.treeModel.isExternal(nodeRef)) {
            list = this.treeModel.getChild(nodeRef, 0);
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, 1);
            shadowNode3.child0 = this.buildRecursivelyShadowTree((NodeRef)((Object)list), shadowNode3);
            shadowNode4.child1 = this.buildRecursivelyShadowTree(nodeRef2, shadowNode4);
        }
        return shadowNode2;
    }

    private int mapOriginalToShadowNumber(int n) {
        assert (n >= 0);
        assert (n < this.treeExternalCount + this.treeInternalCount);
        int n2 = n;
        if (n >= this.treeExternalCount) {
            n2 += this.ancestorCount;
        }
        return n2;
    }

    @Override
    public String toString() {
        return TreeUtils.newick(this);
    }

    @Override
    public boolean isVariable() {
        return this.treeModel instanceof AbstractModel && ((AbstractModel)((Object)this.treeModel)).isVariable();
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        double d;
        assert (nodeRef != null);
        this.checkShadowTree();
        ShadowNode shadowNode = (ShadowNode)nodeRef;
        int n = shadowNode.getOriginalNumber();
        if (n >= 0) {
            d = this.treeModel.getNodeHeight(shadowNode.getOriginalNode());
        } else {
            AncestralTaxonInTree ancestralTaxonInTree = shadowNode.ancestor;
            if (ancestralTaxonInTree.isOnAncestralPath()) {
                double d2 = ancestralTaxonInTree.getHeight();
                if (shadowNode.isExternal()) {
                    d2 -= ancestralTaxonInTree.getPseudoBranchLength();
                }
                double d3 = this.treeModel.getNodeHeight(this.treeModel.getRoot());
                d = d2 = Math.min(d3, d2);
            } else {
                d = shadowNode.isExternal() ? this.treeModel.getNodeHeight(shadowNode.parent.parent.getOriginalNode()) - ancestralTaxonInTree.getPseudoBranchLength() : this.treeModel.getNodeHeight(shadowNode.parent.getOriginalNode());
            }
        }
        return d;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        System.err.println("DIE");
        assert (nodeRef != null);
        this.checkShadowTree();
        ShadowNode shadowNode = (ShadowNode)nodeRef;
        if (!shadowNode.isUsed()) {
            return 0.0;
        }
        int n = shadowNode.getOriginalNumber();
        if (n >= 0) {
            return this.treeModel.getBranchLength(shadowNode.getOriginalNode());
        }
        if (shadowNode.isExternal()) {
            return shadowNode.ancestor.getPseudoBranchLength();
        }
        return 0.0;
    }

    private void storeNodeStructure() {
        int n;
        int n2 = this.nodes.length;
        if (this.storedNodes == null) {
            this.storedNodes = new ShadowNode[n2];
            for (n = 0; n < n2; ++n) {
                this.storedNodes[n] = new ShadowNode();
            }
        }
        for (n = 0; n < n2; ++n) {
            this.storedNodes[n].adoptValues(this.nodes[n], this.storedNodes);
        }
    }

    @Override
    protected void storeState() {
        assert (this.nodes != null);
        this.savedValidShadowTree = this.validShadowTree;
        if (this.validShadowTree) {
            this.storeNodeStructure();
            this.storedRootNumber = this.root.getNumber();
            if (this.hasAncestralPathTaxa) {
                this.savedAncestralPathNodeNumbers = new HashSet<Integer>(this.ancestralPathNodeNumbers);
            }
        }
    }

    @Override
    protected void restoreState() {
        assert (this.storedNodes != null);
        this.validShadowTree = this.savedValidShadowTree;
        if (this.validShadowTree) {
            ShadowNode[] shadowNodeArray = this.nodes;
            this.nodes = this.storedNodes;
            this.storedNodes = shadowNodeArray;
            this.root = this.nodes[this.storedRootNumber];
            if (this.hasAncestralPathTaxa) {
                Set<Integer> set = this.ancestralPathNodeNumbers;
                this.ancestralPathNodeNumbers = this.savedAncestralPathNodeNumbers;
                this.savedAncestralPathNodeNumbers = set;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (!(object instanceof TreeChangedEvent)) {
                if (!(object instanceof Parameter)) throw new IllegalArgumentException("TreeModel should not generate other objects");
                return;
            }
            TreeChangedEvent treeChangedEvent = (TreeChangedEvent)object;
            if (this.ancestors.size() == 1 && this.ancestors.get(0).isAtRoot()) {
                NodeRef nodeRef = treeChangedEvent.getNode();
                ShadowNode shadowNode = this.nodes[this.mapOriginalToShadowNumber(nodeRef.getNumber())];
                this.fireModelChanged(new RemappedTreeChangeEvent(treeChangedEvent, shadowNode), n);
                if (shadowNode.child0 != null) {
                    this.fireModelChanged(new RemappedTreeChangeEvent(treeChangedEvent, shadowNode.child0), n);
                }
                if (shadowNode.child1 != null) {
                    this.fireModelChanged(new RemappedTreeChangeEvent(treeChangedEvent, shadowNode.child1), n);
                }
                if (treeChangedEvent.isOnlyHeightChanged()) return;
                if (nodeRef == this.treeModel.getRoot()) return;
                this.validShadowTree = false;
                return;
            }
            if (treeChangedEvent.isTreeChanged()) {
                this.validShadowTree = false;
                this.fireModelChanged(TreeChangedEvent.create());
                return;
            }
            if (!treeChangedEvent.isNodeChanged()) throw new IllegalArgumentException("TreeModel should not generate other events");
            NodeRef nodeRef = treeChangedEvent.getNode();
            if (nodeRef != null) {
                ShadowNode shadowNode = this.nodes[this.mapOriginalToShadowNumber(nodeRef.getNumber())];
                if (!shadowNode.isExternal() && shadowNode.child0.ancestor != null) {
                    if (shadowNode.parent != null) {
                        this.fireModelChanged(new RemappedTreeChangeEvent(treeChangedEvent, shadowNode.parent), n);
                    }
                    this.fireModelChanged(new RemappedTreeChangeEvent(treeChangedEvent, shadowNode.child0), n);
                    shadowNode = shadowNode.child1;
                }
                if (this.hasAncestralPathTaxa && treeChangedEvent.isHeightChanged()) {
                    ShadowNode shadowNode2;
                    NodeRef nodeRef2 = treeChangedEvent.getNode();
                    if (this.ancestralPathNodeNumbers.contains(treeChangedEvent.getNode().getNumber()) && (this.isExtraNode((shadowNode2 = this.nodes[this.mapOriginalToShadowNumber(nodeRef.getNumber())]).parent) || this.isExtraNode(shadowNode2.child0) || this.isExtraNode(shadowNode2.child1))) {
                        this.validShadowTree = false;
                        this.fireModelChanged(new TreeChangedEvent.WholeTree());
                    }
                }
                object = new RemappedTreeChangeEvent(treeChangedEvent, shadowNode);
            }
            this.fireModelChanged(object, n);
            return;
        }
        if (!(model instanceof AncestralTaxonInTree)) throw new IllegalArgumentException("Illegal model");
        if (!this.ancestors.contains(model)) throw new IllegalArgumentException("Illegal model");
        if (!this.hasAncestralPathTaxa) {
            this.fireModelChanged(new TreeChangedEvent.WholeTree());
            return;
        }
        AncestralTaxonInTree ancestralTaxonInTree = (AncestralTaxonInTree)model;
        double d = ancestralTaxonInTree.getHeight();
        this.validShadowTree = false;
        ShadowNode shadowNode = this.nodes[this.mapOriginalToShadowNumber(ancestralTaxonInTree.getNode().getNumber())];
        while (shadowNode.parent != null && this.getNodeHeight(shadowNode) < d) {
            shadowNode = shadowNode.parent;
        }
        this.safeFireNodeChangedRecursion(shadowNode);
    }

    private void safeFireNodeChangedRecursion(ShadowNode shadowNode) {
        this.safeFireNodeChanged(shadowNode);
        if (shadowNode.child0 != null) {
            this.safeFireNodeChangedRecursion(shadowNode.child0);
        }
        if (shadowNode.child1 != null) {
            this.safeFireNodeChangedRecursion(shadowNode.child1);
        }
    }

    private boolean isExtraNode(ShadowNode shadowNode) {
        return shadowNode != null && shadowNode.originalNumber < 0;
    }

    private void safeFireNodeChanged(NodeRef nodeRef) {
        if (nodeRef != null) {
            this.fireModelChanged(new TreeChangedEvent.NodeOnTree(nodeRef));
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public NodeRef getRoot() {
        this.checkShadowTree();
        return this.root;
    }

    @Override
    public int getNodeCount() {
        return this.externalCount + this.internalCount;
    }

    @Override
    public NodeRef getNode(int n) {
        assert (n >= 0 && n < this.externalCount + this.internalCount);
        this.checkShadowTree();
        return this.nodes[n];
    }

    @Override
    public NodeRef getInternalNode(int n) {
        assert (n >= 0 && n < this.internalCount);
        this.checkShadowTree();
        return this.nodes[n + this.externalCount];
    }

    @Override
    public NodeRef getExternalNode(int n) {
        assert (n >= 0 && n < this.externalCount);
        this.checkShadowTree();
        return this.nodes[n];
    }

    @Override
    public int getExternalNodeCount() {
        return this.externalCount;
    }

    @Override
    public int getInternalNodeCount() {
        return this.internalCount;
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        int n = ((ShadowNode)nodeRef).getOriginalNumber();
        if (n >= 0) {
            return this.treeModel.getNodeTaxon(this.treeModel.getNode(n));
        }
        return this.getTaxonByTreeIndex(nodeRef.getNumber());
    }

    @Override
    public boolean hasNodeHeights() {
        return this.treeModel.hasNodeHeights();
    }

    @Override
    public boolean hasBranchLengths() {
        return this.treeModel.hasBranchLengths();
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return ((ShadowNode)nodeRef).isExternal();
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return nodeRef == this.root;
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        if (((ShadowNode)nodeRef).isExternal()) {
            return 0;
        }
        return 2;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return ((ShadowNode)nodeRef).getChild(n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return ((ShadowNode)nodeRef).parent;
    }

    @Override
    public Tree getCopy() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean beginTreeEdit() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void endTreeEdit() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setAttribute(String string, Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Object getAttribute(String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Iterator<String> getAttributeNames() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setTaxonId(int n, String string) {
        this.treeModel.setTaxonId(n, string);
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getTaxonCount() {
        return this.treeModel.getTaxonCount() + this.ancestorCount;
    }

    @Override
    public Taxon getTaxon(int n) {
        Taxon taxon = n < this.treeExternalCount ? this.treeModel.getTaxon(n) : this.getTaxonByTreeIndex(n);
        return taxon;
    }

    @Override
    public String getTaxonId(int n) {
        String string;
        if (n < this.treeExternalCount) {
            string = this.treeModel.getTaxonId(n);
        } else {
            Taxon taxon = this.getTaxonByTreeIndex(n);
            string = taxon.getId();
        }
        return string;
    }

    @Override
    public int getTaxonIndex(String string) {
        return TaxonList.Utils.getTaxonIndex(this, string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.treeModel.getTaxonIndex(taxon);
        if (n != -1) {
            return n;
        }
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public List<Taxon> asList() {
        return TaxonList.Utils.asList(this);
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (n < this.treeModel.getExternalNodeCount()) {
            return this.treeModel.getTaxonAttribute(n, string);
        }
        Taxon taxon = this.getTaxonByTreeIndex(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return null;
    }

    @Override
    public Iterator<Taxon> iterator() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Units.Type getUnits() {
        return this.treeModel.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.treeModel.setUnits(type);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "TreeModel with ghost / travel history lineages";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2020_ACCOMMODATING);
    }

    private Taxon getTaxonByTreeIndex(int n) {
        if (n >= this.externalCount) {
            return null;
        }
        return this.ancestors.get(n - this.treeExternalCount).getTaxon();
    }

    private void setupClamps() {
        this.nodeToClampMap.clear();
        AncestralTraitTreeModel.recursiveSetupMrcaClamps(this.treeModel, this.treeModel.getRoot(), new BitSet(), this.clampList, this.nodeToClampMap);
        this.setupAncestralPathClamps(this.treeModel, this.clampList, this.nodeToClampMap);
    }

    private static void addAncestralTaxonToMap(Map<Integer, List<AncestralTaxonInTree>> map, int n, AncestralTaxonInTree ancestralTaxonInTree) {
        ArrayList<AncestralTaxonInTree> arrayList = map.containsKey(n) ? map.get(n) : new ArrayList<AncestralTaxonInTree>();
        arrayList.add(ancestralTaxonInTree);
        map.put(n, arrayList);
    }

    private void setupAncestralPathClamps(Tree tree, Map<BitSet, AncestralTaxonInTree> map, Map<Integer, List<AncestralTaxonInTree>> map2) {
        this.hasAncestralPathTaxa = false;
        this.ancestralPathNodeNumbers.clear();
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            boolean bl;
            NodeRef nodeRef = tree.getExternalNode(i);
            BitSet bitSet = new BitSet();
            bitSet.set(nodeRef.getNumber());
            if (!map.containsKey(bitSet)) continue;
            AncestralTaxonInTree ancestralTaxonInTree = map.get(bitSet);
            ancestralTaxonInTree.setTipNode(nodeRef);
            this.ancestralPathNodeNumbers.add(nodeRef.getNumber());
            double d = ancestralTaxonInTree.getHeight();
            assert (d > 0.0);
            NodeRef nodeRef2 = tree.getParent(nodeRef);
            double d2 = tree.getNodeHeight(nodeRef2);
            boolean bl2 = bl = tree.getChild(nodeRef2, 0) == nodeRef;
            while (d2 < d && nodeRef2 != tree.getRoot()) {
                nodeRef = nodeRef2;
                this.ancestralPathNodeNumbers.add(nodeRef.getNumber());
                nodeRef2 = tree.getParent(nodeRef2);
                d2 = tree.getNodeHeight(nodeRef2);
                bl = tree.getChild(nodeRef2, 0) == nodeRef;
            }
            this.ancestralPathNodeNumbers.add(nodeRef2.getNumber());
            ancestralTaxonInTree.setNode(nodeRef2, bl ? 0 : 1);
            AncestralTraitTreeModel.addAncestralTaxonToMap(map2, nodeRef2.getNumber(), ancestralTaxonInTree);
            this.hasAncestralPathTaxa = true;
        }
    }

    private static void recursiveSetupMrcaClamps(Tree tree, NodeRef nodeRef, BitSet bitSet, Map<BitSet, AncestralTaxonInTree> map, Map<Integer, List<AncestralTaxonInTree>> map2) {
        if (tree.isExternal(nodeRef)) {
            bitSet.set(nodeRef.getNumber());
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                BitSet bitSet2 = new BitSet();
                AncestralTraitTreeModel.recursiveSetupMrcaClamps(tree, nodeRef2, bitSet2, map, map2);
                bitSet.or(bitSet2);
            }
            if (map.containsKey(bitSet)) {
                AncestralTaxonInTree ancestralTaxonInTree = map.get(bitSet);
                ancestralTaxonInTree.setNode(nodeRef);
                AncestralTraitTreeModel.addAncestralTaxonToMap(map2, nodeRef.getNumber(), ancestralTaxonInTree);
            }
        }
    }

    private void addRestrictedPartials(AncestralTaxonInTree ancestralTaxonInTree, int n) {
        this.clampList.put(ancestralTaxonInTree.getTipBitSet(), ancestralTaxonInTree);
        this.addModel(ancestralTaxonInTree);
        ancestralTaxonInTree.setIndex(n);
    }

    public class ShadowNode
    implements NodeRef {
        private int number = -1;
        private int originalNumber = -1;
        private AncestralTaxonInTree ancestor = null;
        private ShadowNode child0 = null;
        private ShadowNode child1 = null;
        private ShadowNode parent = null;
        private boolean used = false;

        private ShadowNode() {
        }

        private ShadowNode(int n, NodeRef nodeRef, AncestralTaxonInTree ancestralTaxonInTree) {
            this.number = n;
            this.originalNumber = nodeRef != null ? nodeRef.getNumber() : -1;
            this.ancestor = ancestralTaxonInTree;
            this.used = true;
        }

        private void adoptValues(ShadowNode shadowNode, ShadowNode[] shadowNodeArray) {
            this.number = shadowNode.number;
            this.originalNumber = shadowNode.originalNumber;
            this.ancestor = shadowNode.ancestor;
            this.used = shadowNode.used;
            this.child0 = shadowNode.child0 != null ? shadowNodeArray[shadowNode.child0.getNumber()] : null;
            this.child1 = shadowNode.child1 != null ? shadowNodeArray[shadowNode.child1.getNumber()] : null;
            this.parent = shadowNode.parent != null ? shadowNodeArray[shadowNode.parent.getNumber()] : null;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            throw new RuntimeException("Node number is not modifiable");
        }

        private int getOriginalNumber() {
            return this.originalNumber;
        }

        private NodeRef getOriginalNode() {
            return this.originalNumber >= 0 ? AncestralTraitTreeModel.this.treeModel.getNode(this.originalNumber) : null;
        }

        private NodeRef getChild(int n) {
            if (n == 0) {
                return this.child0;
            }
            if (n == 1) {
                return this.child1;
            }
            throw new IllegalArgumentException("Binary trees only!");
        }

        private boolean isExternal() {
            return this.child0 == null && this.child1 == null;
        }

        public String toString() {
            int n = this.parent != null ? this.parent.getNumber() : -1;
            int n2 = this.child0 != null ? this.child0.getNumber() : -1;
            int n3 = this.child1 != null ? this.child1.getNumber() : -1;
            String string = this.ancestor != null ? this.ancestor.getTaxon().getId() : "-1";
            String string2 = this.used ? "true" : "false";
            double d = AncestralTraitTreeModel.this.getNodeHeight(this);
            boolean bl = this.isExternal();
            int n4 = AncestralTraitTreeModel.this.getChildCount(this);
            return "node " + this.number + " " + n + " " + n2 + " " + n3 + " : " + this.originalNumber + " " + string + " " + string2 + " " + d + " " + bl + " " + n4;
        }

        private boolean isUsed() {
            return this.used;
        }

        private void setUnused() {
            this.used = false;
        }
    }

    private class NodeHeightBoundsWithAncestor
    implements Bounds<Double> {
        private final Parameter nodeHeightParameter;

        public NodeHeightBoundsWithAncestor(Parameter parameter) {
            this.nodeHeightParameter = parameter;
        }

        @Override
        public Double getUpperLimit(int n) {
            ShadowNode shadowNode = AncestralTraitTreeModel.this.getNodeOfHeightParameter(this.nodeHeightParameter);
            return AncestralTraitTreeModel.this.getNodeHeight(shadowNode.parent);
        }

        @Override
        public Double getLowerLimit(int n) {
            return 0.0;
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }

    private class RemappedTreeChangeEvent
    implements TreeChangedEvent {
        private final TreeChangedEvent event;
        private final NodeRef node;

        private RemappedTreeChangeEvent(TreeChangedEvent treeChangedEvent, NodeRef nodeRef) {
            this.event = treeChangedEvent;
            this.node = nodeRef;
        }

        @Override
        public int getIndex() {
            return this.event.getIndex();
        }

        @Override
        public NodeRef getNode() {
            return this.node;
        }

        @Override
        public Parameter getParameter() {
            return this.event.getParameter();
        }

        @Override
        public boolean isNodeChanged() {
            return this.event.isNodeChanged();
        }

        @Override
        public boolean isTreeChanged() {
            return this.event.isTreeChanged();
        }

        @Override
        public boolean isNodeOrderChanged() {
            return this.event.isNodeOrderChanged();
        }

        @Override
        public boolean isNodeParameterChanged() {
            return this.event.isNodeParameterChanged();
        }

        @Override
        public boolean isHeightChanged() {
            return this.event.isHeightChanged();
        }

        @Override
        public boolean isOnlyHeightChanged() {
            return this.event.isOnlyHeightChanged();
        }
    }
}

