/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.JointGradient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelGradientExecutor {
    private final ExecutorService pool;
    private final List<DerivativeCaller> derivativeCaller;
    public static final boolean DEBUG_PARALLEL_EVALUATION = false;

    public ParallelGradientExecutor(int n, List<GradientWrtParameterProvider> list) {
        int n2;
        assert (list.size() > 1);
        if (n <= 0) {
            this.pool = Executors.newCachedThreadPool();
        } else {
            n2 = Math.min(n, list.size());
            this.pool = Executors.newFixedThreadPool(n2);
        }
        this.derivativeCaller = new ArrayList<DerivativeCaller>(list.size());
        for (n2 = 0; n2 < list.size(); ++n2) {
            this.derivativeCaller.add(new DerivativeCaller(list.get(n2), n2));
        }
    }

    public double[] getDerivativeLogDensityInParallel(JointGradient.DerivativeType derivativeType, Reducer reducer, int n) {
        for (DerivativeCaller object2 : this.derivativeCaller) {
            object2.setDerivativeType(derivativeType);
        }
        Object object = null;
        try {
            List<Future<double[]>> exception = this.pool.invokeAll(this.derivativeCaller);
            object = reducer.reduce(exception, n);
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private static class DerivativeCaller
    implements Callable<double[]> {
        private final GradientWrtParameterProvider gradient;
        private final int index;
        private JointGradient.DerivativeType type;

        public DerivativeCaller(GradientWrtParameterProvider gradientWrtParameterProvider, int n) {
            this.gradient = gradientWrtParameterProvider;
            this.index = n;
        }

        @Override
        public double[] call() throws Exception {
            return this.type.getDerivativeLogDensity(this.gradient);
        }

        public void setDerivativeType(JointGradient.DerivativeType derivativeType) {
            this.type = derivativeType;
        }
    }

    static interface Reducer {
        public double[] reduce(List<Future<double[]>> var1, int var2) throws ExecutionException, InterruptedException;
    }
}

