/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class DeathSqlBuilder<T extends Death>
extends CriteriaSqlBuilder<T> {
    private static final String DEATH_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/death.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));
    private final List<String> DEFAULT_SELECT_COLUMNS = new ArrayList<String>(Arrays.asList("d.person_id", "d.cause_concept_id"));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return DEATH_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "coalesce(C.cause_concept_id,0)";
            }
            case DURATION: {
                return "CAST(1 as int)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Death:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((Death)criteria).codesetId, "d.cause_concept_id", ((Death)criteria).deathSourceConcept, "d.cause_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        return query;
    }

    @Override
    protected List<String> resolveSelectClauses(T criteria) {
        ArrayList<String> selectCols = new ArrayList<String>(this.DEFAULT_SELECT_COLUMNS);
        if (((Death)criteria).deathType != null && ((Death)criteria).deathType.length > 0) {
            selectCols.add("d.death_type_concept_id");
        }
        if (((Death)criteria).dateAdjustment != null) {
            selectCols.add(BuilderUtils.getDateAdjustmentExpression(((Death)criteria).dateAdjustment, "d.death_date", "DATEADD(day,1,d.death_date)"));
        } else {
            selectCols.add("d.death_date as start_date, DATEADD(day,1,d.death_date) as end_date");
        }
        return selectCols;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((Death)criteria).age != null || ((Death)criteria).gender != null && ((Death)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        List<String> whereClauses = super.resolveWhereClauses(criteria);
        if (((Death)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((Death)criteria).occurrenceStartDate));
        }
        if (((Death)criteria).deathType != null && ((Death)criteria).deathType.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Death)criteria).deathType);
            whereClauses.add(String.format("C.death_type_concept_id %s in (%s)", ((Death)criteria).deathTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Death)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.start_date) - P.year_of_birth", ((Death)criteria).age));
        }
        if (((Death)criteria).gender != null && ((Death)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Death)criteria).gender), (String)",")));
        }
        return whereClauses;
    }
}

