/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPLogical
extends REXPVector {
    protected byte[] payload;
    static final int NA_internal = Integer.MIN_VALUE;
    public static final byte NA = -128;
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;

    public static boolean isNA(byte by) {
        return by == -128;
    }

    public REXPLogical(boolean bl) {
        this.payload = new byte[]{bl ? (byte)1 : 0};
    }

    public REXPLogical(byte by) {
        this.payload = new byte[]{by};
    }

    public REXPLogical(byte[] byArray) {
        this.payload = byArray == null ? new byte[]{} : byArray;
    }

    public REXPLogical(boolean[] blArray) {
        this.payload = new byte[blArray == null ? 0 : blArray.length];
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                this.payload[i] = blArray[i] ? (byte)1 : 0;
            }
        }
    }

    public REXPLogical(byte[] byArray, REXPList rEXPList) {
        super(rEXPList);
        this.payload = byArray == null ? new byte[]{} : byArray;
    }

    public REXPLogical(boolean[] blArray, REXPList rEXPList) {
        super(rEXPList);
        this.payload = new byte[blArray == null ? 0 : blArray.length];
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                this.payload[i] = blArray[i] ? (byte)1 : 0;
            }
        }
    }

    public int length() {
        return this.payload.length;
    }

    public boolean isLogical() {
        return true;
    }

    public int[] asIntegers() {
        int[] nArray = new int[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            nArray[i] = this.payload[i] == -128 ? Integer.MIN_VALUE : (this.payload[i] == 0 ? 0 : 1);
        }
        return nArray;
    }

    public byte[] asBytes() {
        return this.payload;
    }

    public double[] asDoubles() {
        double[] dArray = new double[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            dArray[i] = this.payload[i] == -128 ? REXPDouble.NA : (this.payload[i] == 0 ? 0.0 : 1.0);
        }
        return dArray;
    }

    public String[] asStrings() {
        String[] stringArray = new String[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            stringArray[i] = this.payload[i] == -128 ? "NA" : (this.payload[i] == 0 ? "FALSE" : "TRUE");
        }
        return stringArray;
    }

    public boolean[] isNA() {
        boolean[] blArray = new boolean[this.payload.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.payload[i] == -128;
        }
        return blArray;
    }

    public boolean[] isTRUE() {
        boolean[] blArray = new boolean[this.payload.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.payload[i] != -128 && this.payload[i] != 0;
        }
        return blArray;
    }

    public boolean[] isFALSE() {
        boolean[] blArray = new boolean[this.payload.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.payload[i] == 0;
        }
        return blArray;
    }

    public boolean[] isTrue() {
        return this.isTRUE();
    }

    public boolean[] isFalse() {
        return this.isFALSE();
    }

    public String toDebugString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toDebugString() + "{");
        for (n = 0; n < this.payload.length && n < maxDebugItems; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.payload[n] == -128 ? "NA" : (this.payload[n] == 0 ? "FALSE" : "TRUE"));
        }
        if (n < this.payload.length) {
            stringBuffer.append(",..");
        }
        return stringBuffer.toString() + "}";
    }
}

