/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import java.util.Objects;

public class TsPeriodSelector
implements Cloneable {
    public static final Day DEF_BEG = new Day(1900, Month.January, 0);
    public static final Day DEF_END = new Day(2020, Month.December, 30);
    private PeriodSelectorType type_ = PeriodSelectorType.All;
    private Day d0_ = DEF_BEG;
    private Day d1_ = DEF_END;
    private int n0_;
    private int n1_;

    public boolean equals(TsPeriodSelector ps) {
        if (ps == this) {
            return true;
        }
        if (ps == null && this.type_ == PeriodSelectorType.All) {
            return true;
        }
        if (this.type_ != ps.type_) {
            return false;
        }
        switch (this.type_) {
            case Excluding: {
                return this.n0_ == ps.n0_ && this.n1_ == ps.n1_;
            }
            case Last: {
                return this.n1_ == ps.n1_;
            }
            case First: {
                return this.n0_ == ps.n0_;
            }
            case Between: {
                return this.d0_.equals((Object)ps.d0_) && this.d1_.equals((Object)ps.d1_);
            }
            case From: {
                return this.d0_.equals((Object)ps.d0_);
            }
            case To: {
                return this.d1_.equals((Object)ps.d1_);
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsPeriodSelector && this.equals((TsPeriodSelector)obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode((Object)this.type_);
        hash = 97 * hash + this.n0_;
        hash = 97 * hash + this.n1_;
        return hash;
    }

    public TsPeriodSelector() {
    }

    @Deprecated
    public TsPeriodSelector(TsPeriodSelector p) {
        this.type_ = p.type_;
        this.n0_ = p.n0_;
        this.n1_ = p.n1_;
        this.d0_ = p.d0_ != null ? p.d0_ : DEF_BEG;
        this.d1_ = p.d1_ != null ? p.d1_ : DEF_END;
    }

    public void all() {
        this.doClear();
    }

    public void between(Day d0, Day d1) {
        this.doClear();
        if (d1.isBefore(d0)) {
            this.type_ = PeriodSelectorType.None;
        } else {
            this.type_ = PeriodSelectorType.Between;
            this.d0_ = d0;
            this.d1_ = d1;
        }
    }

    public TsPeriodSelector clone() {
        try {
            TsPeriodSelector obj = (TsPeriodSelector)super.clone();
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    private void doClear() {
        this.n0_ = 0;
        this.n1_ = 0;
        this.d0_ = DEF_BEG;
        this.d1_ = DEF_END;
        this.type_ = PeriodSelectorType.All;
    }

    public void excluding(int n0, int n1) {
        this.doClear();
        this.type_ = PeriodSelectorType.Excluding;
        this.n0_ = n0;
        this.n1_ = n1;
    }

    public void first(int n) {
        this.doClear();
        this.type_ = PeriodSelectorType.First;
        this.n0_ = n;
    }

    public void from(Day d0) {
        this.doClear();
        this.type_ = PeriodSelectorType.From;
        this.d0_ = d0;
    }

    public Day getD0() {
        return this.d0_;
    }

    @Deprecated
    public void setD0(Day d) {
        this.d0_ = d;
    }

    public Day getD1() {
        return this.d1_;
    }

    @Deprecated
    public void setD1(Day d) {
        this.d1_ = d;
    }

    public int getN0() {
        return this.n0_;
    }

    @Deprecated
    public void setN0(int i) {
        this.n0_ = i;
    }

    public int getN1() {
        return this.n1_;
    }

    @Deprecated
    public void setN1(int i) {
        this.n1_ = i;
    }

    public PeriodSelectorType getType() {
        return this.type_;
    }

    @Deprecated
    public void setType(PeriodSelectorType type) {
        this.type_ = type;
    }

    public void last(int n) {
        this.doClear();
        this.type_ = PeriodSelectorType.Last;
        this.n1_ = n;
    }

    public void none() {
        this.doClear();
        this.type_ = PeriodSelectorType.None;
    }

    public void to(Day d1) {
        this.doClear();
        this.type_ = PeriodSelectorType.To;
        this.d1_ = d1;
    }

    public String toString() {
        switch (this.type_) {
            case Between: {
                return this.d0_.toString() + " - " + this.d1_.toString();
            }
            case Excluding: {
                if (this.n0_ == 0 && this.n1_ == 0) {
                    return "";
                }
                StringBuilder builder = new StringBuilder();
                builder.append("All but ");
                if (this.n0_ != 0) {
                    builder.append("first ");
                    if (this.n0_ > 1) {
                        builder.append(this.n0_).append(" periods");
                    } else if (this.n0_ > 0) {
                        builder.append("period");
                    } else if (this.n0_ < -1) {
                        builder.append(-this.n0_).append(" years");
                    } else if (this.n0_ < 0) {
                        builder.append("year");
                    }
                    if (this.n1_ != 0) {
                        builder.append(" and ");
                    }
                }
                if (this.n1_ != 0) {
                    builder.append("last ");
                    if (this.n1_ > 1) {
                        builder.append(this.n1_).append(" periods");
                    } else if (this.n1_ > 0) {
                        builder.append("period");
                    } else if (this.n1_ < -1) {
                        builder.append(-this.n1_).append(" years");
                    } else if (this.n1_ < 0) {
                        builder.append("year");
                    }
                }
                return builder.toString();
            }
            case First: {
                StringBuilder builder = new StringBuilder();
                if (this.n0_ > 0) {
                    builder.append("first ");
                    if (this.n0_ > 1) {
                        builder.append(this.n0_).append(" periods");
                    } else {
                        builder.append("period");
                    }
                    if (this.n1_ > 0) {
                        builder.append(" and ");
                    }
                }
                return builder.toString();
            }
            case Last: {
                StringBuilder builder = new StringBuilder();
                if (this.n1_ > 0) {
                    builder.append("last ");
                    if (this.n1_ > 1) {
                        builder.append(this.n1_).append(" periods");
                    } else {
                        builder.append("period");
                    }
                }
                return builder.toString();
            }
            case From: {
                return "From " + this.d0_.toString();
            }
            case To: {
                return "Until " + this.d1_.toString();
            }
            case All: {
                return "All";
            }
            case None: {
                return "None";
            }
        }
        return "";
    }

    public boolean isAll() {
        return this.type_ == PeriodSelectorType.All;
    }

    public boolean isNone() {
        return this.type_ == PeriodSelectorType.None;
    }
}

