/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.realarray.mut;

import net.sf.jclec.realarray.RealArrayIndividual;
import net.sf.jclec.realarray.UniformMutator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuhlenbeinMutator<I extends RealArrayIndividual>
extends UniformMutator<I> {
    private static final long serialVersionUID = -3059929043243398240L;
    protected double mutationRange;

    public double getMutationRange() {
        return this.mutationRange;
    }

    public void setMutationRange(double mutationRange) {
        this.mutationRange = mutationRange;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double mutationRange = settings.getDouble("[@mutation-range]", 0.1);
        this.setMutationRange(mutationRange);
    }

    public boolean equals(Object other) {
        if (other instanceof MuhlenbeinMutator) {
            MuhlenbeinMutator o = (MuhlenbeinMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusMutProb, o.locusMutProb);
            eb.append(this.mutationRange, o.mutationRange);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected double defaultLocusMutProb() {
        return 0.05;
    }

    @Override
    protected void doLocusMutation(double[] parentChromosome, double[] mutantChromosome, int locusIndex) {
        double rang = this.mutationRange * this.genotypeSchema[locusIndex].efWidth();
        double gamma = 0.0;
        int k = 0;
        while (k <= 15) {
            gamma += (double)(this.randgen.raw() < 0.0625 ? 1 : 0) * Math.pow(2.0, -k);
            ++k;
        }
        mutantChromosome[locusIndex] = this.randgen.coin() ? parentChromosome[locusIndex] + rang * gamma : parentChromosome[locusIndex] - rang * gamma;
        mutantChromosome[locusIndex] = this.genotypeSchema[locusIndex].nearestOf(mutantChromosome[locusIndex]);
    }
}

