/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import moa.MOAObject;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import weka.core.Utils;

public class MOAUtils {
    public static MOAObject fromCommandLine(ClassOption option, String commandline) {
        return MOAUtils.fromCommandLine(option.getRequiredType(), commandline);
    }

    public static MOAObject fromCommandLine(Class requiredType, String commandline) {
        MOAObject result;
        try {
            String[] tmpOptions = Utils.splitOptions(commandline);
            String classname = tmpOptions[0];
            tmpOptions[0] = "";
            try {
                result = (MOAObject)Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                result = (MOAObject)Class.forName(requiredType.getPackage().getName() + "." + classname).newInstance();
            }
            if (result instanceof AbstractOptionHandler) {
                ((AbstractOptionHandler)result).getOptions().setViaCLIString(Utils.joinOptions(tmpOptions));
                ((AbstractOptionHandler)result).prepareForUse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static MOAObject fromOption(ClassOption option) {
        return MOAUtils.fromCommandLine(option.getRequiredType(), option.getValueAsCLIString());
    }

    public static String toCommandLine(MOAObject obj) {
        String result = obj.getClass().getName();
        if (obj instanceof AbstractOptionHandler) {
            result = result + " " + ((AbstractOptionHandler)obj).getOptions().getAsCLIString();
        }
        return result.trim();
    }
}

