/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.experiment.Experiment;

public class RunNumberPanel
extends JPanel {
    private static final long serialVersionUID = -1644336658426067852L;
    protected JTextField m_LowerText = new JTextField("1");
    protected JTextField m_UpperText = new JTextField("10");
    protected Experiment m_Exp;

    public RunNumberPanel() {
        this.m_LowerText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RunNumberPanel.this.m_Exp.setRunLower(RunNumberPanel.this.getLower());
            }
        });
        this.m_LowerText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RunNumberPanel.this.m_Exp.setRunLower(RunNumberPanel.this.getLower());
            }
        });
        this.m_UpperText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RunNumberPanel.this.m_Exp.setRunUpper(RunNumberPanel.this.getUpper());
            }
        });
        this.m_UpperText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RunNumberPanel.this.m_Exp.setRunUpper(RunNumberPanel.this.getUpper());
            }
        });
        this.m_LowerText.setEnabled(false);
        this.m_UpperText.setEnabled(false);
        this.setLayout(new GridLayout(1, 2));
        this.setBorder(BorderFactory.createTitledBorder("Runs"));
        Box b1 = new Box(0);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(new JLabel("From:", 4));
        b1.add(Box.createHorizontalStrut(5));
        b1.add(this.m_LowerText);
        this.add(b1);
        Box b2 = new Box(0);
        b2.add(Box.createHorizontalStrut(10));
        b2.add(new JLabel("To:", 4));
        b2.add(Box.createHorizontalStrut(5));
        b2.add(this.m_UpperText);
        this.add(b2);
    }

    public RunNumberPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_LowerText.setText("" + this.m_Exp.getRunLower());
        this.m_UpperText.setText("" + this.m_Exp.getRunUpper());
        this.m_LowerText.setEnabled(true);
        this.m_UpperText.setEnabled(true);
    }

    public int getLower() {
        int result = 1;
        try {
            result = Integer.parseInt(this.m_LowerText.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(1, result);
    }

    public int getUpper() {
        int result = 1;
        try {
            result = Integer.parseInt(this.m_UpperText.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(1, result);
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Dataset List Editor");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)new RunNumberPanel(new Experiment()), "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

