(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25990,        499]*)
(*NotebookOutlinePosition[     26640,        522]*)
(*  CellTagsIndexPosition[     26596,        518]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(galambosAfun[w_] := 
      1\  - \ \((w^\((\(-alpha\))\)\  + \ \((1\  - \ 
                    w)\)^\((\(-alpha\))\))\)^\((\(-1\)/alpha)\)\)], "Input"],

Cell[BoxData[
    \(pnorm[x_]\  := \ 0.5\ \ Erf[x/Sqrt[2]]\ \  + \ 0.5\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[pnorm[0]]\)], "Input"],

Cell[BoxData[
    \(0.5`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(huslerReissAfun[x_] := \ 
      x*pnorm[1/alpha + 0.5*alpha*Log[x/\((1 - x)\)]] + \(\((1 - 
              x)\)\(*\)\(pnorm[
            1/alpha - 0.5*alpha*Log[x/\((1 - x)\)]]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(pEVCopula[Afun_] := 
      Simplify[Exp[Log[u1\ u2]\ *Afun[Log[u1]/Log[u1\ u2]]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dEVCopula[Afun_] := 
      Module[\[IndentingNewLine]{cdf, d1, d2}, \[IndentingNewLine]cdf = 
          pEVCopula[Afun]; \[IndentingNewLine]d1 = 
          FullSimplify[D[cdf, u1]]; \[IndentingNewLine]d2 = 
          FullSimplify[
            D[d1, u2]]; \[IndentingNewLine]d2\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(dEVCopula\\)\\\" is similar to existing \
symbol \\\"\\!\\(pEVCopula\\)\\\". \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pGalambosCopula = pEVCopula[galambosAfun]\)], "Input"],

Cell[BoxData[
    \(\((u1\ u2)\)\^\(1 - \((\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \
\((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(\(-1\)/alpha\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dGalambosCopula = dEVCopula[galambosAfun]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(dGalambosCopula\\)\\\" is similar to \
existing symbol \\\"\\!\\(pGalambosCopula\\)\\\". \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \(\((\((u1\ u2)\)\^\(-\((\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \
\((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(\(-1\)/alpha\)\)\ \((\((1 - \
Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\
\)\^\(\(-2\)/alpha\)\ \((\((\(Log[u1]\ \((\(-Log[u1]\) + Log[u1\ \
u2])\)\)\/Log[u1\ u2]\^2)\)\^alpha\ \((2\ Log[
                        u1]\ \((\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \
\((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(2/alpha\)\ \((Log[u1] - 
                          Log[u1\ u2])\) - 
                    Log[u1\ u2]\^2 + \((\((1 - Log[u1]\/Log[u1\ \
u2])\)\^\(-alpha\) + \((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(1\/alpha\)\ \
Log[u1\ u2]\ \((1 + alpha + 
                          Log[u1\ u2])\))\) + \((\((1 - Log[u1]\/Log[u1\ u2])\
\)\^\(-alpha\) + \((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(1\/alpha\)\ \((\
\((1 - Log[u1]\/Log[u1\ u2])\)\^\(2\ alpha\)\ \((Log[u1] - 
                          Log[u1\ u2])\)\ \((Log[
                              u1]\ \((\((1 - Log[u1]\/Log[u1\ \
u2])\)\^\(-alpha\) + \((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(1\/alpha\) \
- Log[u1\ u2])\) + 
                    Log[u1]\ \((Log[u1]\/Log[u1\ u2])\)\^\(2\ alpha\)\ \((\((\
\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \((Log[u1]\/Log[u1\ \
u2])\)\^\(-alpha\))\)\^\(1\/alpha\)\ \((Log[u1] - Log[u1\ u2])\) + 
                          Log[u1\ u2])\))\))\))\)/\((Log[
            u1]\ \((\((1 - Log[u1]\/Log[u1\ u2])\)\^alpha + \
\((Log[u1]\/Log[u1\ u2])\)\^alpha)\)\^2\ \((Log[u1] - 
              Log[u1\ u2])\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv1pGalambosCopula\  = \ D[pGalambosCopula, \ u1]\)], "Input"],

Cell[BoxData[
    \(\((u1\ u2)\)\^\(1 - \((\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \
\((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(\(-1\)/alpha\)\)\ \((\(1 - \
\((\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \((Log[u1]\/Log[u1\ \
u2])\)\^\(-alpha\))\)\^\(\(-1\)/alpha\)\)\/u1 + \
\(\(1\/alpha\)\((\((\(-alpha\)\ \((Log[u1]\/\(u1\ Log[u1\ u2]\^2\) - 
                        1\/\(u1\ Log[u1\ u2]\))\)\ \((1 - Log[u1]\/Log[u1\ \
u2])\)\^\(\(-1\) - alpha\) - 
                  alpha\ \((\(-\(Log[u1]\/\(u1\ Log[u1\ u2]\^2\)\)\) + 
                        1\/\(u1\ Log[u1\ u2]\))\)\ \((Log[u1]\/Log[u1\ u2])\)\
\^\(\(-1\) - alpha\))\)\ \((\((1 - Log[u1]\/Log[u1\ u2])\)\^\(-alpha\) + \
\((Log[u1]\/Log[u1\ u2])\)\^\(-alpha\))\)\^\(\(-1\) - 1\/alpha\)\ Log[
                u1\ u2])\)\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<galambos.expr\>", \ 
      FortranForm[{pGalambosCopula, \ dGalambosCopula, \ 
          deriv1pGalambosCopula, \ 
          AfunGalambosCopula}], "\<Table\>"]\)], "Input"],

Cell[BoxData[
    \("galambos.expr"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pHuslerReissCopula = pEVCopula[huslerReissAfun]\)], "Input"],

Cell[BoxData[
    \(u1\^\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\
\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\
\ Log[u1\ u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\
\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dHuslerReissCopula = dEVCopula[huslerReissAfun]\)], "Input"],

Cell[BoxData[
    \(\(-\(\((0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ u1\^\(\
\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha + \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\)\) + \
0.5`\ Erf[0.7071067811865475`\/alpha - 0.35355339059327373`\ alpha\ \
Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]])\)\ \((Log[u1] - 1.`\ \
Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ Log[
                u1]\ \((\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ \
Erf[0.7071067811865475`\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\
\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]]\)\/u1 + 
                  0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \
\((\(-1.`\)\ Log[u1] + 1.`\ Log[
                            u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ \((1.`\ \
Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) - 
                        1.`\/\(1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ \
u2]\))\))\))\)/\((u2\ \((\(-1.`\)\ Log[u1] + 
                  1.`\ Log[
                      u1\ u2])\))\)\)\) + \
\((\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ u1\^\(\
\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha + \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\)\) + \
0.5`\ Erf[0.7071067811865475`\/alpha - 0.35355339059327373`\ alpha\ \
Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]])\)\ \((Log[u1] - 1.`\ \
Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ \((\(-0.19947114020071632`\)\ alpha\ Log[
                    u1] - 0.5`\ \
\[ExponentialE]\^\(\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \((1.`\
\ Log[u1] + Erf[0.7071067811865475`\/alpha - 
                            0.35355339059327373`\ alpha\ Log[
                                Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\) - 1.`\ Log[u1\ u2])\) + 
                0.19947114020071632`\ alpha\ Log[
                    u1\ u2])\)\ \((\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\
\ Erf[0.7071067811865475`\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\
\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]]\)\/u1 + 
                0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \
\((\(-1.`\)\ Log[u1] + 
                      1.`\ Log[
                          u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ \((1.`\ \
Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) - 
                      1.`\/\(1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ u2]\))\))\))\
\)/\((u2\ \((\(-1.`\)\ Log[u1] + 
                1.`\ Log[
                    u1\ u2])\))\) - \((0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ u1\^\(\
\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha + \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\)\) + \
0.5`\ Erf[0.7071067811865475`\/alpha - 0.35355339059327373`\ alpha\ \
Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]])\)\ \((Log[u1] - 1.`\ \
Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ Log[
              u1]\ \((\(-\(\(1\/\(u1\ Log[
                          u1\ u2]\)\)\((1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\
\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - 
                                0.35355339059327373`\ alpha\ Log[
                                    Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ \
Log[u1\ u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\))\)\)\) + 
                Log[u1\ u2]\ \((\(\(1\/\(u1\ Log[u1\ u2]\^2\)\)\((1.`\ \
\((\(\(0.5`\)\(\[InvisibleSpace]\)\) + 
                              0.5`\ Erf[
                                  0.7071067811865475`\/alpha - 
                                    0.35355339059327373`\ alpha\ Log[
                                        
                                        Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ \
Log[u1\ u2]\)]])\)\ \((Log[u1] - 
                              1.`\ Log[
                                  u1\ u2])\))\)\) + \(\(\(0.`\)\(\
\[InvisibleSpace]\)\) + 0.`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\)\/\(u1\ Log[u1\ u2]\) + \(\(1\/\(Log[u1]\ Log[
                              u1\ u2]\)\)\((0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \((Log[
                                u1] - 
                              1.`\ Log[u1\ u2])\)\ \((\(-1.`\)\ Log[u1] + 
                              1.`\ Log[
                                  u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ \
\((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) - 
                              1.`\/\(1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ \
u2]\))\))\)\))\))\))\)/\((u2\ \((\(-1.`\)\ Log[u1] + 
                1.`\ Log[
                    u1\ u2])\))\) + \
\((\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ u1\^\(\
\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha + \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\)\) + \
0.5`\ Erf[0.7071067811865475`\/alpha - 0.35355339059327373`\ alpha\ \
Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]])\)\ \((Log[u1] - 1.`\ \
Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ \((\(-0.19947114020071632`\)\ alpha\ Log[
                    u1] - 0.5`\ \
\[ExponentialE]\^\(\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \((1.`\
\ Log[u1] + Erf[0.7071067811865475`\/alpha - 
                            0.35355339059327373`\ alpha\ Log[
                                Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\) - 1.`\ Log[u1\ u2])\) + 
                0.19947114020071632`\ alpha\ Log[
                    u1\ u2])\)\ \((\(-\(\(1\/\(u1\ Log[
                          u1\ u2]\)\)\((1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\
\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - 
                                0.35355339059327373`\ alpha\ Log[
                                    Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ \
Log[u1\ u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\))\)\)\) + 
                Log[u1\ u2]\ \((\(\(1\/\(u1\ Log[u1\ u2]\^2\)\)\((1.`\ \
\((\(\(0.5`\)\(\[InvisibleSpace]\)\) + 
                              0.5`\ Erf[
                                  0.7071067811865475`\/alpha - 
                                    0.35355339059327373`\ alpha\ Log[
                                        Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ \
Log[u1\ u2]\)]])\)\ \((Log[u1] - 
                              1.`\ Log[
                                  u1\ u2])\))\)\) + \(\(\(0.`\)\(\
\[InvisibleSpace]\)\) + 0.`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]]\)\/\(u1\ Log[u1\ u2]\) + \(\(1\/\(Log[u1]\ Log[
                              u1\ u2]\)\)\((0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \((Log[
                                u1] - 
                              1.`\ Log[u1\ u2])\)\ \((\(-1.`\)\ Log[u1] + 
                              1.`\ Log[
                                  u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ \
\((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) - 
                              1.`\/\(1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ \
u2]\))\))\)\))\))\))\)/\((u2\ \((\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2])\))\) + 
      u1\^\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\
\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\
\ Log[u1\ u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\
\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ \
\((\(0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)\^2\)\)\/\(1.`\ u1\ u2\ Log[u1] - 1.`\ u1\ u2\ Log[u1\ u2]\) + 
            0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \
\((\(-1.`\)\ Log[u1] + 
                  1.`\ Log[
                      u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ u2\ \((1.`\ \
Log[u1] - 1.`\ Log[u1\ u2])\)\^3\) - \(1.`\ u1\)\/\(u2\ \((1.`\ u1\ Log[u1] - \
1.`\ u1\ Log[u1\ u2])\)\^2\))\) + \
\(\(1\/u2\)\((\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)\^2\)\ \((\(0.`\ alpha\ Log[u1]\)\/\(u1\ \((1.`\ Log[u1] - 1.`\ \
Log[u1\ u2])\)\^2\) - \(0.19947114020071632`\ alpha\)\/\(1.`\ u1\ Log[u1] - \
1.`\ u1\ Log[u1\ u2]\))\))\)\) + \(\(1\/u2\)\((0.14104739588693904`\ alpha\^2\
\ \[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \
\((\(0.`\ Log[u1]\)\/\(u1\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) - 
                    1.`\/\(1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ u2]\))\)\ \
\((0.7071067811865475`\/alpha + 
                    0.35355339059327373`\ alpha\ Log[
                        Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\))\)\))\) + 
      u1\^\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\
\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\
\ Log[u1\ u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\
\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ \((\(\(0.`\)\
\(\[InvisibleSpace]\)\) + 
            Log[u1]\ \((\(0.`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\)\/\(u1\
\ u2\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) + 
                  0.`\/\(u1\ u2\ Log[u1\ u2]\^2\))\) + 
            Erf[0.7071067811865475`\/alpha - 
                  0.35355339059327373`\ alpha\ Log[
                      Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]]\ \
\((\(0.`\ Log[u1]\)\/\(u1\ u2\ Log[u1\ u2]\^2\) + 
                  0.`\/\(u1\ u2\ Log[u1\ u2]\))\) + \(\(1\/\(u1\ u2\ Log[
                    u1\ u2]\)\)\((\(\(0.`\)\(\[InvisibleSpace]\)\) + 
                0.`\ alpha\ \
\[ExponentialE]\^\(\(-\(0.4999999999999999`\/alpha\^2\)\) + 0.`\ alpha\^2 - \
0.12499999999999997`\ alpha\^2\ Log[\(-\(\(1.`\ Log[u1]\)\/\(1.`\ Log[u1] - \
1.`\ Log[u1\ u2]\)\)\)]\^2\)\ \((\(-\(\(1.`\ Log[u1]\)\/\(1.`\ Log[u1] - 1.`\ \
Log[u1\ u2]\)\)\))\)\^\(\(\(1.5`\)\(\[InvisibleSpace]\)\) + 0.`\ \
alpha\^2\))\)\) + \(0.`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\)\/\(u1\
\ u2\ \((\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2])\)\) + \(0.19947114020071632`\ \
alpha\ \[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)\^2\)\ u1\ Log[u1]\)\/\(u2\ \((1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ \
u2])\)\^2\) - \(0.2992067103010745`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)\^2\)\)\/\(1.`\ u1\ u2\ Log[u1] - 1.`\ u1\ u2\ Log[u1\ u2]\) + \
\((0.`\ alpha\^3\ \[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)\^2\)\ Log[u1]\ Log[
                    Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)/\((u1\ u2\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^2)\) - \
\((0.04986778505017906`\ alpha\^3\ \[ExponentialE]\^\(-\((0.7071067811865475`\
\/alpha - 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\
\ Log[u1\ u2]\)])\)\^2\)\ Log[
                    Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)/\((0.9999999999999999`\ u1\ u2\ Log[u1] - 
                  0.9999999999999999`\ u1\ u2\ Log[u1\ u2])\) + 
            Log[u1\ u2]\ \((\(0.`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \
Log[u1]\)\/\(u1\ u2\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^3\) + \(0.`\ \
alpha\ \[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\)\^2\)\)\/\(u1\ u2\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^2\) - \
\(0.09973557010035816`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ u1\)\/\
\(u2\ \((1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ u2])\)\^2\) + 
                  alpha\^3\ \[ExponentialE]\^\(-\((0.7071067811865475`\/alpha \
- 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\
\ u2]\)])\)\^2\)\ \((0.`\/\(u1\ u2\ \((1.`\ Log[u1] - 1.`\ Log[u1\ \
u2])\)\^2\) + \(0.04986778505017907`\ u1\)\/\(u2\ \((1.`\ u1\ Log[u1] - 1.`\ \
u1\ Log[u1\ u2])\)\^2\))\)\ Log[
                      Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\) + 
            Log[u1\ u2]\^2\ \((\(0.`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\)\/\(u1\
\ u2\ \((1.`\ Log[u1] - 1.`\ Log[u1\ u2])\)\^3\) + \((alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ u1\ \
\((\(-0.09973557010035816`\) - 
                            0.04986778505017907`\ alpha\^2\ Log[
                                Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)])\))\)/\((u2\ Log[
                          u1]\ \((1.`\ u1\ Log[u1] - 1.`\ u1\ Log[u1\ \
u2])\)\^2)\))\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv1pHuslerReissCopula = D[pHuslerReissCopula, \ u1]\)], "Input"],

Cell[BoxData[
    \(u1\^\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\
\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\
\ Log[u1\ u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \((\(\(0.5`\)\(\
\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ \
\((\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha \
+ 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\
\ u2]\)]]\)\/u1 + 
            0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha + 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \
\((\(-1.`\)\ Log[u1] + 
                  1.`\ Log[
                      u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ \((\(-1.`\)\ \
Log[u1] + 1.`\ Log[u1\ u2])\)\^2\) + 
                  1\/\(u1\ \((\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2])\)\))\))\) \
+ u1\^\(\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ \
Erf[0.7071067811865475`\/alpha + 0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\
\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)]]\)\ \((u1\ u2)\)\^\(-\(\(1.`\ \
\((\(\(0.5`\)\(\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\)\)\/Log[u1\ u2]\)\)\ \
\((\(-\(\(1\/\(u1\ Log[
                      u1\ u2]\)\)\((1.`\ \((\(\(0.5`\)\(\[InvisibleSpace]\)\) \
+ 0.5`\ Erf[0.7071067811865475`\/alpha - 
                            0.35355339059327373`\ alpha\ Log[
                                Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\ \((Log[u1] - 1.`\ Log[u1\ u2])\))\)\)\) + 
            Log[u1\ u2]\ \((\(\(1\/\(u1\ Log[u1\ u2]\^2\)\)\((1.`\ \
\((\(\(0.5`\)\(\[InvisibleSpace]\)\) + 
                          0.5`\ Erf[
                              0.7071067811865475`\/alpha - 
                                0.35355339059327373`\ alpha\ Log[
                                    Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ \
Log[u1\ u2]\)]])\)\ \((Log[u1] - 
                          1.`\ Log[
                              u1\ u2])\))\)\) + \(0.`\ \((\(\(0.5`\)\(\
\[InvisibleSpace]\)\) + 0.5`\ Erf[0.7071067811865475`\/alpha - \
0.35355339059327373`\ alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ \
u2]\)]])\)\)\/\(u1\ Log[u1\ u2]\) + \(\(1\/\(Log[u1]\ Log[
                          u1\ u2]\)\)\((0.19947114020071632`\ alpha\ \
\[ExponentialE]\^\(-\((0.7071067811865475`\/alpha - 0.35355339059327373`\ \
alpha\ Log[Log[u1]\/\(\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2]\)])\)\^2\)\ \((Log[
                            u1] - 1.`\ Log[u1\ u2])\)\ \((\(-1.`\)\ Log[u1] + 
                          1.`\ Log[
                              u1\ u2])\)\ \((\(0.`\ Log[u1]\)\/\(u1\ \
\((\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2])\)\^2\) + 
                          1\/\(u1\ \((\(-1.`\)\ Log[u1] + 1.`\ Log[u1\ u2])\)\
\))\))\)\))\))\)\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{741, 948},
WindowMargins->{{60, Automatic}, {Automatic, 0}},
ShowSelection->True
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 171, 3, 27, "Input"],
Cell[1928, 56, 83, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2036, 61, 44, 1, 27, "Input"],
Cell[2083, 64, 38, 1, 27, "Output"]
}, Open  ]],
Cell[2136, 68, 218, 4, 43, "Input"],
Cell[2357, 74, 114, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2496, 80, 329, 6, 123, "Input"],
Cell[2828, 88, 368, 6, 33, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3233, 99, 74, 1, 27, "Input"],
Cell[3310, 102, 165, 2, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3512, 109, 74, 1, 27, "Input"],
Cell[3589, 112, 378, 5, 33, "Message"],
Cell[3970, 119, 1591, 25, 598, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5598, 149, 85, 1, 27, "Input"],
Cell[5686, 152, 803, 12, 272, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6526, 169, 202, 4, 59, "Input"],
Cell[6731, 175, 49, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6817, 181, 80, 1, 27, "Input"],
Cell[6900, 184, 457, 6, 80, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7394, 195, 80, 1, 27, "Input"],
Cell[7477, 198, 15274, 240, 3815, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22788, 443, 87, 1, 27, "Input"],
Cell[22878, 446, 3096, 50, 708, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

