/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.charges.Electronegativity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IBondDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class BondSigmaElectronegativityDescriptor
extends AbstractBondDescriptor
implements IBondDescriptor {
    private int maxIterations = 6;
    private final Electronegativity electronegativity = new Electronegativity();
    private static final String[] NAMES = new String[]{"elecSigB"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondSigmaElectronegativity", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("SigmaElectronegativityDescriptor only expects one parameter");
        }
        if (params.length == 0) {
            return;
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, e);
    }

    public DescriptorValue calculate(IBond aBond, IAtomContainer atomContainer) {
        IBond bond;
        IAtomContainer ac;
        try {
            ac = atomContainer.clone();
            bond = ac.getBond(atomContainer.indexOf(aBond));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)ac);
        }
        catch (CloneNotSupportedException | CDKException e) {
            return this.getDummyDescriptorValue((Exception)e);
        }
        if (this.maxIterations != -1 && this.maxIterations != 0) {
            this.electronegativity.setMaxIterations(this.maxIterations);
        }
        double electroAtom1 = this.electronegativity.calculateSigmaElectronegativity(ac, bond.getBegin());
        double electroAtom2 = this.electronegativity.calculateSigmaElectronegativity(ac, bond.getEnd());
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Math.abs(electroAtom1 - electroAtom2)), NAMES);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    public Object getParameterType(String name) {
        return 0;
    }
}

