/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.memory.trailing.trail.IOperationTrail;

public class OperationTrail
implements IOperationTrail {
    private final double loadfactor;
    private IOperation[] valueStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public OperationTrail(int nUpdates, int nWorlds, double loadfactor) {
        this.valueStack = new IOperation[nUpdates];
        this.worldStartLevels = new int[nWorlds];
        this.loadfactor = loadfactor;
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
        if (worldIndex == this.worldStartLevels.length - 1) {
            this.resizeWorldCapacity((int)((double)this.worldStartLevels.length * this.loadfactor));
        }
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            this.valueStack[--this.currentLevel].undo();
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            this.valueStack[--this.currentLevel] = null;
        }
    }

    @Override
    public void savePreviousState(IOperation operation) {
        this.valueStack[this.currentLevel++] = operation;
        if (this.currentLevel == this.valueStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    @Override
    public void savePreviousStateAt(IOperation operation, int at, int currentWorldIndex) {
        this.savePreviousState(null);
        int length = this.currentLevel - this.worldStartLevels[at];
        System.arraycopy(this.valueStack, this.worldStartLevels[at], this.valueStack, this.worldStartLevels[at] + 1, length);
        this.valueStack[this.worldStartLevels[at]] = operation;
        int t = currentWorldIndex;
        while (t > at) {
            int n = t--;
            this.worldStartLevels[n] = this.worldStartLevels[n] + 1;
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = (int)((double)this.valueStack.length * this.loadfactor);
        IOperation[] tmp2 = new IOperation[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
    }

    private void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

