/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class EWMAChartDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    public FloatOption lambdaOption = new FloatOption("lambda", 'l', "Lambda parameter of the EWMA Chart Method", 0.2, 0.0, 3.4028234663852886E38);
    private double m_n;
    private double m_sum;
    private double m_p;
    private double m_s;
    private double lambda;
    private double z_t;

    public EWMAChartDM() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.m_n = 1.0;
        this.m_sum = 0.0;
        this.m_p = 0.0;
        this.m_s = 0.0;
        this.z_t = 0.0;
        this.lambda = this.lambdaOption.getValue();
    }

    @Override
    public void input(double prediction) {
        if (this.isChangeDetected || !this.isInitialized) {
            this.resetLearning();
            this.isInitialized = true;
        }
        this.m_sum += prediction;
        this.m_p = this.m_sum / this.m_n;
        this.m_s = Math.sqrt(this.m_p * (1.0 - this.m_p) * this.lambda * (1.0 - Math.pow(1.0 - this.lambda, 2.0 * this.m_n)) / (2.0 - this.lambda));
        this.m_n += 1.0;
        this.z_t += this.lambda * (prediction - this.z_t);
        double L_t = 3.97 - 6.56 * this.m_p + 48.73 * Math.pow(this.m_p, 3.0) - 330.13 * Math.pow(this.m_p, 5.0) + 848.18 * Math.pow(this.m_p, 7.0);
        this.estimation = this.m_p;
        this.isChangeDetected = false;
        this.isWarningZone = false;
        this.delay = 0.0;
        if (this.m_n < (double)this.minNumInstancesOption.getValue()) {
            return;
        }
        if (this.m_n > (double)this.minNumInstancesOption.getValue() && this.z_t > this.m_p + L_t * this.m_s) {
            this.isChangeDetected = true;
        } else {
            this.isWarningZone = this.z_t > this.m_p + 0.5 * L_t * this.m_s;
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

