/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.dstream;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moa.cluster.CFCluster;
import moa.clusterers.dstream.DensityGrid;
import moa.clusterers.macro.NonConvexCluster;

public class GridCluster
extends NonConvexCluster {
    private static final long serialVersionUID = -6498733665209706370L;
    private HashMap<DensityGrid, Boolean> grids = new HashMap();
    private HashMap<DensityGrid, Boolean> visited;
    private int clusterLabel;

    public GridCluster(CFCluster cluster, List<CFCluster> microclusters, int label) {
        super(cluster, microclusters);
        this.clusterLabel = label;
    }

    public GridCluster(CFCluster cluster, List<CFCluster> microclusters, HashMap<DensityGrid, Boolean> hashMap, int label) {
        super(cluster, microclusters);
        for (Map.Entry<DensityGrid, Boolean> grid : hashMap.entrySet()) {
            DensityGrid dg = grid.getKey();
            Boolean inside = grid.getValue();
            this.grids.put(dg, inside);
        }
        this.clusterLabel = label;
    }

    public void addGrid(DensityGrid dg) {
        Boolean inside = this.isInside(dg);
        this.grids.put(dg, inside);
        for (Map.Entry<DensityGrid, Boolean> gridToUpdate : this.grids.entrySet()) {
            Boolean inside2U = gridToUpdate.getValue();
            if (inside2U.booleanValue()) continue;
            DensityGrid dg2U = gridToUpdate.getKey();
            this.grids.put(dg2U, this.isInside(dg2U));
        }
    }

    public void removeGrid(DensityGrid dg) {
        this.grids.remove(dg);
    }

    public void absorbCluster(GridCluster gridClus) {
        DensityGrid dg;
        HashMap<DensityGrid, Boolean> newCluster = new HashMap<DensityGrid, Boolean>();
        for (Map.Entry<DensityGrid, Boolean> entry : gridClus.getGrids().entrySet()) {
            dg = entry.getKey();
            this.grids.put(dg, false);
        }
        for (Map.Entry<DensityGrid, Boolean> entry : this.getGrids().entrySet()) {
            dg = entry.getKey();
            Boolean inside = this.isInside(dg);
            newCluster.put(dg, inside);
        }
        this.grids = newCluster;
    }

    public Boolean isInside(DensityGrid dg) {
        for (DensityGrid dgprime : dg.getNeighbours()) {
            if (this.grids.containsKey(dgprime)) continue;
            return false;
        }
        return true;
    }

    public Boolean isInside(DensityGrid dg, DensityGrid dgH) {
        for (DensityGrid dgprime : dg.getNeighbours()) {
            if (this.grids.containsKey(dgprime) || dgprime.equals(dgH)) continue;
            return false;
        }
        return true;
    }

    public int getClusterLabel() {
        return this.clusterLabel;
    }

    public HashMap<DensityGrid, Boolean> getGrids() {
        return this.grids;
    }

    public void setClusterLabel(int clusterLabel) {
        this.clusterLabel = clusterLabel;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("Cluster of grids.");
    }

    @Override
    public double getWeight() {
        return this.grids.size();
    }

    public boolean isConnected() {
        this.visited = new HashMap();
        Iterator<DensityGrid> initIter = this.grids.keySet().iterator();
        if (initIter.hasNext()) {
            boolean changesMade;
            DensityGrid dg = initIter.next();
            this.visited.put(dg, this.grids.get(dg));
            do {
                changesMade = false;
                Iterator<Map.Entry<DensityGrid, Boolean>> visIter = this.visited.entrySet().iterator();
                HashMap<DensityGrid, Boolean> toAdd = new HashMap<DensityGrid, Boolean>();
                while (visIter.hasNext() && toAdd.isEmpty()) {
                    Map.Entry<DensityGrid, Boolean> toVisit = visIter.next();
                    DensityGrid dg2V = toVisit.getKey();
                    for (DensityGrid dg2VN : dg2V.getNeighbours()) {
                        if (!this.grids.containsKey(dg2VN) || this.visited.containsKey(dg2VN)) continue;
                        toAdd.put(dg2VN, this.grids.get(dg2VN));
                    }
                }
                if (toAdd.isEmpty()) continue;
                this.visited.putAll(toAdd);
                changesMade = true;
            } while (changesMade);
        }
        return this.visited.size() == this.grids.size();
    }

    @Override
    public double getInclusionProbability(Instance instance) {
        for (Map.Entry<DensityGrid, Boolean> grid : this.grids.entrySet()) {
            DensityGrid dg = grid.getKey();
            if (dg.getInclusionProbability(instance) != 1.0) continue;
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(10 * this.grids.size());
        for (Map.Entry<DensityGrid, Boolean> grids : this.grids.entrySet()) {
            DensityGrid dg = grids.getKey();
            Boolean inside = grids.getValue();
            sb.append("(" + dg.toString());
            if (inside.booleanValue()) {
                sb.append(" In)");
                continue;
            }
            sb.append(" Out)");
        }
        return sb.toString();
    }
}

