/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.AbstractGraphCanvas;
import moa.gui.visualization.GraphScatter;
import moa.gui.visualization.ParamGraphAxes;

public class ParamGraphCanvas
extends AbstractGraphCanvas {
    private static final long serialVersionUID = 1L;
    private double[] variedParamValues;

    public ParamGraphCanvas() {
        super(new ParamGraphAxes(), new GraphScatter());
    }

    public void setGraph(MeasureCollection[] measures, MeasureCollection[] measureStds, double[] variedParamValues, Color[] colors) {
        this.measures = measures;
        this.variedParamValues = variedParamValues;
        ((GraphScatter)this.plotPanel).setGraph(measures, measureStds, variedParamValues, colors);
        this.updateCanvas(false);
    }

    @Override
    public double getMinXValue() {
        if (this.variedParamValues == null) {
            return 0.0;
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.variedParamValues.length; ++i) {
            if (!(this.variedParamValues[i] < min)) continue;
            min = this.variedParamValues[i];
        }
        return min;
    }

    @Override
    public double getMaxXValue() {
        if (this.variedParamValues == null) {
            return 0.0;
        }
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.variedParamValues.length; ++i) {
            if (!(this.variedParamValues[i] > max)) continue;
            max = this.variedParamValues[i];
        }
        return max;
    }

    @Override
    public void setSize() {
        this.setSize((int)(this.baseWidth * this.x_resolution), (int)(this.baseHeight * this.y_resolution));
    }

    @Override
    public void setPreferredSize() {
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
    }
}

