/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators.cd;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.ArrayList;
import java.util.Random;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.streams.clustering.ClusterEvent;
import moa.streams.generators.cd.ConceptDriftGenerator;
import moa.tasks.TaskMonitor;

public abstract class AbstractConceptDriftGenerator
extends AbstractOptionHandler
implements ConceptDriftGenerator {
    protected ArrayList<ClusterEvent> clusterEvents;
    private static final long serialVersionUID = 1L;
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FlagOption notBinaryStreamOption = new FlagOption("notBinaryStream", 'b', "Don't convert to a binary stream of 0 and 1.");
    public IntOption numInstancesConceptOption = new IntOption("numInstancesConcept", 'p', "The number of instances for each concept.", 500, 0, Integer.MAX_VALUE);
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected int period;
    protected int numInstances;
    protected boolean change;

    @Override
    public String getPurposeString() {
        return "Generates a stream problem of predicting concept drift.";
    }

    @Override
    public ArrayList<ClusterEvent> getEventsList() {
        return this.clusterEvents;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
        this.numInstances = 0;
        this.period = this.numInstancesConceptOption.getValue();
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        FastVector<String> binaryLabels = new FastVector<String>();
        binaryLabels.addElement("0");
        binaryLabels.addElement("1");
        if (!this.notBinaryStreamOption.isSet()) {
            attributes.addElement(new Attribute("input", binaryLabels));
        } else {
            attributes.addElement(new Attribute("input"));
        }
        attributes.addElement(new Attribute("change", binaryLabels));
        attributes.addElement(new Attribute("ground truth input"));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.clusterEvents = new ArrayList();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    protected abstract double nextValue();

    private int nextbinaryValue(double num) {
        int res = 0;
        if (this.instanceRandom.nextDouble() <= num) {
            res = 1;
        }
        return res;
    }

    public boolean getChange() {
        return this.change;
    }

    @Override
    public InstanceExample nextInstance() {
        ++this.numInstances;
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setDataset(header);
        double nextValue = this.nextValue();
        if (this.notBinaryStreamOption.isSet()) {
            inst.setValue(0, nextValue);
        } else {
            inst.setValue(0, (double)this.nextbinaryValue(nextValue));
        }
        inst.setValue(1, this.getChange() ? 1.0 : 0.0);
        if (this.getChange()) {
            // empty if block
        }
        inst.setValue(2, nextValue);
        return new InstanceExample(inst);
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

