/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.epidemiology.LambertW;
import dr.evomodel.epidemiology.ODEDemographicFunction;

public class SIRepidemic
extends ODEDemographicFunction {
    private boolean valid = false;
    private double N0 = 0.0;
    private double r = 0.0;
    private double u0 = 0.0;
    private double R0 = 0.0;
    private boolean integrate_intensity = true;
    private double smin = 0.0;
    private double s0 = 0.0;
    private double i0 = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;
    LambertW W;
    private double LAMBDA_MAX = 1000.0;

    public SIRepidemic(Units.Type type) {
        super(type);
        this.nvar = 2;
    }

    public void setN0(double d) {
        this.N0 = d;
        this.RKinit();
    }

    public double getN0() {
        return this.N0;
    }

    public void setGrowthRate(double d) {
        this.r = d;
        this.RKinit();
    }

    public double getGrowthRate() {
        return this.r;
    }

    public void setDoublingTime(double d) {
        this.setGrowthRate(Math.log(2.0) / d);
    }

    public double getDoublingTime() {
        return Math.log(2.0) / this.r;
    }

    public void setu0(double d) {
        this.u0 = d;
        this.RKinit();
    }

    public double getu0() {
        return this.u0;
    }

    public void setR0(double d) {
        this.R0 = d;
        this.RKinit();
    }

    public double getR0() {
        return this.R0;
    }

    public void setIntegrateIntensity() {
        this.integrate_intensity = true;
    }

    public void unsetIntegrateIntensity() {
        this.integrate_intensity = false;
    }

    public double getbeta() {
        return this.getGrowthRate() / (1.0 - 1.0 / this.getR0());
    }

    public double getgamma() {
        return this.getGrowthRate() / (this.getR0() - 1.0);
    }

    public double gets0() {
        return this.s0;
    }

    public double geti0() {
        return this.i0;
    }

    public double getsmin(double d) {
        if (d <= 1.0) {
            return 0.0;
        }
        return -LambertW.branch0(-d * Math.exp(-d)) / d;
    }

    public double s_to_i(double d) {
        double d2 = 1.0 - d + Math.log(d) / this.R0;
        if (d2 < 1.0E-12) {
            d2 = 1.0E-12;
        }
        if (d2 > 0.999999999999) {
            d2 = 0.999999999999;
        }
        return d2;
    }

    public double s_to_u(double d, double d2) {
        return Math.log(d - d2) - Math.log(1.0 - d);
    }

    public double u_to_s(double d, double d2) {
        double d3 = d2 + (1.0 - d2) / (1.0 + Math.exp(-d));
        if (d3 < d2 + 1.0E-12) {
            d3 = d2 + 1.0E-12;
        }
        if (d3 > 0.999999999999) {
            d3 = 0.999999999999;
        }
        return d3;
    }

    public double u_to_i(double d, double d2, double d3) {
        double d4 = d2 + (1.0 - d2) / (1.0 + Math.exp(-d));
        double d5 = 1.0 - d4 + Math.log(d4) / d3;
        if (d5 < 1.0E-12) {
            d5 = 1.0E-12;
        }
        if (d5 > 0.999999999999) {
            d5 = 0.999999999999;
        }
        return d5;
    }

    @Override
    void derivs(double d, double[] dArray, double[] dArray2) {
        double d2;
        double d3 = dArray[0];
        if (!this.integrate_intensity) {
            dArray2[0] = 1.0;
        } else if (d3 < this.LAMBDA_MAX) {
            d2 = this.getDemographicFromPrevalence(dArray, d);
            dArray2[0] = 1.0 / d2;
        } else {
            dArray2[0] = 0.0;
        }
        d2 = this.u_to_s(dArray[1], this.smin);
        if (d2 == 1.0) {
            dArray2[1] = this.beta - this.gamma;
        } else {
            if (d2 < this.smin + 1.0E-6) {
                d2 = this.smin + 1.0E-6;
            }
            dArray2[1] = (this.beta * d2 * (1.0 - d2) + this.gamma * d2 * Math.log(d2)) * (1.0 - this.smin) / (d2 - this.smin) / (1.0 - d2);
        }
        if (Double.isNaN(dArray2[0]) | Double.isInfinite(dArray2[0]) | Double.isNaN(dArray2[1]) | Double.isInfinite(dArray2[1])) {
            System.out.println("t = " + d + ", y = {" + dArray[0] + ", " + dArray[1] + "}, s = " + d2 + ", dydt = {" + dArray2[0] + ", " + dArray2[1] + "}");
            this.derivs(d, dArray, dArray2);
        }
    }

    @Override
    double getDemographicFromPrevalence(double[] dArray, double d) {
        double d2 = this.u_to_s(dArray[1], this.smin);
        double d3 = this.u_to_i(dArray[1], this.smin, this.getR0());
        double d4 = this.N0 * this.s0 / this.i0 * d3 / d2;
        if (Double.isNaN(d4) | d4 < 1.0E-12) {
            d4 = 1.0E-12;
        }
        return d4;
    }

    @Override
    public double getDemographic(double d) {
        if (!this.valid) {
            return 0.0;
        }
        double d2 = super.getDemographic(d);
        if (this.Ynow[0] >= this.LAMBDA_MAX) {
            return 0.0;
        }
        return d2;
    }

    @Override
    public double getIntensity(double d) {
        if (!this.valid) {
            return Math.log(0.0);
        }
        double d2 = super.getIntensity(d);
        if (d2 >= this.LAMBDA_MAX) {
            return Math.log(0.0);
        }
        return d2;
    }

    public double getSusceptibles(double d) {
        if (!this.valid) {
            return Math.log(0.0);
        }
        this.Evaluate(d);
        if (this.RKfail) {
            return Math.log(0.0);
        }
        if (this.Ynow[0] >= this.LAMBDA_MAX) {
            return Math.log(0.0);
        }
        return this.u_to_s(this.Ynow[1], this.smin);
    }

    public double getTransformedSusceptibles(double d) {
        if (!this.valid) {
            return Math.log(0.0);
        }
        this.Evaluate(d);
        if (this.RKfail) {
            return Math.log(0.0);
        }
        return this.Ynow[1];
    }

    @Override
    void RKinit() {
        super.RKinit();
        this.valid = true;
        this.smin = this.getsmin(this.getR0());
        this.s0 = this.u_to_s(this.u0, this.smin);
        this.i0 = this.u_to_i(this.u0, this.smin, this.getR0());
        this.beta = this.getbeta();
        this.gamma = this.getgamma();
    }

    @Override
    void setInit() {
        this.Y[0][0] = 0.0;
        this.Y[1][0] = this.u0;
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getu0();
            }
            case 3: {
                return this.getR0();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "u0";
            }
            case 3: {
                return "R0";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    public DemographicFunction getCopy() {
        SIRepidemic sIRepidemic = new SIRepidemic(this.getUnits());
        sIRepidemic.setN0(this.getN0());
        sIRepidemic.setGrowthRate(this.getGrowthRate());
        sIRepidemic.setu0(this.getu0());
        sIRepidemic.setR0(this.getR0());
        return sIRepidemic;
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setu0(d);
                break;
            }
            case 3: {
                this.setR0(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }
}

