/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;

class DelegateFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix2D content;
    protected int row;

    public DelegateFloatMatrix1D(FloatMatrix2D floatMatrix2D, int n) {
        if (n < 0 || n >= floatMatrix2D.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(floatMatrix2D.columns());
        this.row = n;
        this.content = floatMatrix2D;
    }

    public synchronized float getQuick(int n) {
        return this.content.getQuick(this.row, n);
    }

    public FloatMatrix1D like(int n) {
        return this.content.like1D(n);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return this.content.like(n, n2);
    }

    public synchronized void setQuick(int n, float f) {
        this.content.setQuick(this.row, n, f);
    }

    public Object elements() {
        return this.content.elements();
    }

    public FloatMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FloatMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected FloatMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }
}

