/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Formatter;
import java.util.Locale;
import umontreal.iro.lecuyer.probdist.DiscreteDistribution;
import umontreal.iro.lecuyer.util.Misc;

public class EmpiricalDist
extends DiscreteDistribution {
    private double[] sortedObs;
    private int n = 0;
    private double sampleMean;
    private double sampleVariance;
    private double sampleStandardDeviation;

    public EmpiricalDist(double[] dArray) {
        if (dArray.length <= 1) {
            throw new IllegalArgumentException("Two or more observations are needed");
        }
        this.n = dArray.length;
        this.sortedObs = new double[this.n];
        System.arraycopy(dArray, 0, this.sortedObs, 0, this.n);
        this.init();
    }

    public EmpiricalDist(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        double[] dArray = new double[5];
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            string = string.trim();
            for (n = 0; n < string.length() && (string.charAt(n) == '+' || string.charAt(n) == '-' || string.charAt(n) == 'e' || string.charAt(n) == 'E' || string.charAt(n) == '.' || Character.isDigit(string.charAt(n))); ++n) {
            }
            if ((string = string.substring(0, n)).equals("")) continue;
            try {
                dArray[this.n++] = Double.parseDouble(string);
                if (this.n < dArray.length) continue;
                double[] dArray2 = new double[2 * this.n];
                System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                dArray = dArray2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.sortedObs = new double[this.n];
        System.arraycopy(dArray, 0, this.sortedObs, 0, this.n);
        this.init();
    }

    public double prob(int n) {
        if (n >= 0 && n < this.n) {
            return 1.0 / (double)this.n;
        }
        throw new IllegalStateException();
    }

    public double cdf(double d) {
        if (d < this.sortedObs[0]) {
            return 0.0;
        }
        if (d >= this.sortedObs[this.n - 1]) {
            return 1.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(d >= this.sortedObs[i]) || !(d < this.sortedObs[i + 1])) continue;
            return (double)(i + 1) / (double)this.n;
        }
        throw new IllegalStateException();
    }

    public double barF(double d) {
        if (d <= this.sortedObs[0]) {
            return 1.0;
        }
        if (d > this.sortedObs[this.n - 1]) {
            return 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(d > this.sortedObs[i]) || !(d <= this.sortedObs[i + 1])) continue;
            return ((double)this.n - 1.0 - (double)i) / (double)this.n;
        }
        throw new IllegalStateException();
    }

    public double inverseF(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d == 1.0) {
            return this.sortedObs[this.n - 1];
        }
        int n = (int)Math.floor((double)this.n * d);
        return this.sortedObs[n];
    }

    private void init() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.sortedObs.length; ++n) {
            d += this.sortedObs[n];
        }
        this.sampleMean = d / (double)this.n;
        d = 0.0;
        for (n = 0; n < this.n; ++n) {
            double d2 = this.sortedObs[n] - this.sampleMean;
            d += d2 * d2;
        }
        this.sampleVariance = d / (double)(this.n - 1);
        this.sampleStandardDeviation = Math.sqrt(this.sampleVariance);
        this.supportA = this.sortedObs[0];
        this.supportB = this.sortedObs[this.n - 1];
    }

    public double getMean() {
        return this.sampleMean;
    }

    public double getVariance() {
        return this.sampleVariance;
    }

    public double getStandardDeviation() {
        return this.sampleStandardDeviation;
    }

    public double getMedian() {
        if (this.n % 2 == 0) {
            return (this.obs[this.n / 2 - 1] + this.obs[this.n / 2]) / 2.0;
        }
        return this.obs[(this.n - 1) / 2];
    }

    public static double getMedian(double[] dArray, int n) {
        if (n % 2 == 0) {
            return (Misc.quickSelect(dArray, n, n / 2 - 1) + Misc.quickSelect(dArray, n, n / 2)) / 2.0;
        }
        return Misc.quickSelect(dArray, n, (n - 1) / 2);
    }

    public int getN() {
        return this.n;
    }

    public double getObs(int n) {
        return this.sortedObs[n];
    }

    public double getSampleMean() {
        return this.sampleMean;
    }

    public double getSampleVariance() {
        return this.sampleVariance;
    }

    public double getSampleStandardDeviation() {
        return this.sampleStandardDeviation;
    }

    public double getInterQuartileRange() {
        int n = this.n / 2;
        double d = 0.0;
        double d2 = 0.0;
        if (n % 2 == 1) {
            d = this.sortedObs[(n + 1) / 2 - 1];
            d2 = this.sortedObs[this.n - (n + 1) / 2];
        } else {
            d = 0.5 * (this.sortedObs[n / 2 - 1] + this.sortedObs[n / 2 + 1 - 1]);
            d2 = 0.5 * (this.sortedObs[this.n - n / 2] + this.sortedObs[this.n - n / 2 - 1]);
        }
        return d2 - d;
    }

    public double[] getParams() {
        double[] dArray = new double[this.n];
        System.arraycopy(this.sortedObs, 0, dArray, 0, this.n);
        return dArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        formatter.format(this.getClass().getName() + "\n", new Object[0]);
        for (int i = 0; i < this.n; ++i) {
            formatter.format("%f\n", this.sortedObs[i]);
        }
        return stringBuilder.toString();
    }
}

