/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

import com.hp.hpl.jena.datatypes.xsd.AbstractDateTime;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;

public class XSDDuration
extends AbstractDateTime {
    private static final int[][] DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};
    private int[][] fDuration = null;

    public XSDDuration(Object value) {
        super(value);
    }

    public int getYears() {
        return this.data[0];
    }

    public int getMonths() {
        return this.data[1];
    }

    public int getDays() {
        return this.data[2];
    }

    public int getHours() {
        return this.data[3];
    }

    public int getMinutes() {
        return this.data[4];
    }

    public int getFullSeconds() {
        return this.data[5];
    }

    public double getSeconds() {
        return (double)this.data[5] + this.fractionalSeconds;
    }

    public double getTimePart() {
        return (double)(((long)this.data[3] * 60L + (long)this.data[4]) * 60L) + this.getSeconds();
    }

    public String toString() {
        StringBuffer message = new StringBuffer(30);
        int negate = 1;
        if (this.data[0] < 0) {
            message.append('-');
            negate = -1;
        }
        message.append('P');
        message.append(negate * this.data[0]);
        message.append('Y');
        message.append(negate * this.data[1]);
        message.append('M');
        message.append(negate * this.data[2]);
        message.append('D');
        message.append('T');
        message.append(negate * this.data[3]);
        message.append('H');
        message.append(negate * this.data[4]);
        message.append('M');
        message.append(negate * this.data[5]);
        message.append('.');
        XSDAbstractDateTimeType.appendFractionalTime(message, negate * this.data[6], this.data[8]);
        message.append('S');
        return message.toString();
    }

    protected short compareDates(int[] date1, int[] date2, boolean strict) {
        int[] tempB;
        int[] tempA;
        short resultB = 2;
        short resultA = this.compareOrder(date1, date2);
        if (resultA == 0) {
            return 0;
        }
        if (this.fDuration == null) {
            this.fDuration = new int[2][9];
        }
        if ((resultA = this.compareOrder(tempA = this.addDuration(date1, 0, this.fDuration[0]), tempB = this.addDuration(date2, 0, this.fDuration[1]))) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, 1, this.fDuration[0]);
        resultB = this.compareOrder(tempA, tempB = this.addDuration(date2, 1, this.fDuration[1]));
        if ((resultA = this.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, 2, this.fDuration[0]);
        resultB = this.compareOrder(tempA, tempB = this.addDuration(date2, 2, this.fDuration[1]));
        if ((resultA = this.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, 3, this.fDuration[0]);
        tempB = this.addDuration(date2, 3, this.fDuration[1]);
        resultB = this.compareOrder(tempA, tempB);
        resultA = this.compareResults(resultA, resultB, strict);
        return resultA;
    }

    private short compareResults(short resultA, short resultB, boolean strict) {
        if (resultB == 2) {
            return 2;
        }
        if (resultA != resultB && strict) {
            return 2;
        }
        if (resultA != resultB && !strict) {
            if (resultA != 0 && resultB != 0) {
                return 2;
            }
            return resultA != 0 ? resultA : resultB;
        }
        return resultA;
    }

    private int[] addDuration(int[] date, int index, int[] duration) {
        this.resetDateObj(duration);
        int temp = DATETIMES[index][1] + date[1];
        duration[1] = XSDDuration.modulo(temp, 1, 13);
        int carry = XSDDuration.fQuotient(temp, 1, 13);
        duration[0] = DATETIMES[index][0] + date[0] + carry;
        temp = DATETIMES[index][5] + date[5];
        carry = XSDDuration.fQuotient(temp, 60);
        duration[5] = XSDDuration.mod(temp, 60, carry);
        temp = DATETIMES[index][4] + date[4] + carry;
        carry = XSDDuration.fQuotient(temp, 60);
        duration[4] = XSDDuration.mod(temp, 60, carry);
        temp = DATETIMES[index][3] + date[3] + carry;
        carry = XSDDuration.fQuotient(temp, 24);
        duration[3] = XSDDuration.mod(temp, 24, carry);
        duration[2] = DATETIMES[index][2] + date[2] + carry;
        while (true) {
            temp = XSDDuration.maxDayInMonthFor(duration[0], duration[1]);
            if (duration[2] < 1) {
                duration[2] = duration[2] + XSDDuration.maxDayInMonthFor(duration[0], duration[1] - 1);
                carry = -1;
            } else {
                if (duration[2] <= temp) break;
                duration[2] = duration[2] - temp;
                carry = 1;
            }
            temp = duration[1] + carry;
            duration[1] = XSDDuration.modulo(temp, 1, 13);
            duration[0] = duration[0] + XSDDuration.fQuotient(temp, 1, 13);
        }
        duration[7] = 90;
        return duration;
    }
}

