/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.cp.common.util.preprocessor.AbstractDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveSModel;
import choco.cp.model.CPModel;
import choco.cp.model.preprocessor.ModelDetectorFactory;
import choco.cp.solver.CPSolver;
import choco.cp.solver.preprocessor.PPModelToCPSolver;
import choco.cp.solver.preprocessor.PPSearch;
import choco.cp.solver.preprocessor.PreProcessConfiguration;
import choco.cp.solver.preprocessor.SolverDetectorFactory;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.solver.Configuration;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Iterator;

public class PreProcessCPSolver
extends CPSolver {
    private final PPSearch ppsearch;
    private DisjunctiveModel disjMod;
    private DisjunctiveSModel disjSMod;
    private int proptime;

    public PreProcessCPSolver() {
        this(new PreProcessConfiguration());
    }

    public PreProcessCPSolver(Configuration configuration) {
        this(new EnvironmentTrailing(), configuration);
    }

    public PreProcessCPSolver(IEnvironment env, Configuration configuration) {
        super(env, configuration);
        this.mod2sol = new PPModelToCPSolver(this);
        this.ppsearch = new PPSearch();
    }

    public final DisjunctiveModel getDisjModel() {
        return this.disjMod;
    }

    public final DisjunctiveSModel getDisjSModel() {
        if (this.disjSMod == null && this.disjMod != null) {
            this.disjSMod = new DisjunctiveSModel(this, this.disjMod);
        }
        return this.disjSMod;
    }

    public PPModelToCPSolver getMod2Sol() {
        return (PPModelToCPSolver)this.mod2sol;
    }

    public void setRandomValueOrdering(int seed) {
        this.ppsearch.setRandomValueHeuristic(seed);
    }

    @Override
    public void read(Model m) {
        this.model = (CPModel)m;
        this.ppsearch.setModel(this.model);
        super.initReading();
        SolverDetectorFactory.associateIndexes(this.model);
        if (this.configuration.readBoolean("ppcp.detection.intEq")) {
            SolverDetectorFactory.intVarEqDet(this.model, this).applyThenCommit();
        }
        this.mod2sol.readIntegerVariables(this.model);
        this.mod2sol.readRealVariables(this.model);
        this.mod2sol.readSetVariables(this.model);
        this.mod2sol.readConstants(this.model);
        if (this.configuration.readBoolean("ppcp.detection.taskEq")) {
            SolverDetectorFactory.taskVarEqDet(this.model, this).applyThenCommit();
        }
        this.mod2sol.readMultipleVariables(this.model);
        if (this.configuration.readBoolean("ppcp.detection.disjunctive")) {
            SolverDetectorFactory.disjunctionDetector(this.model, this).applyThenCommit();
        }
        if (this.configuration.readBoolean("ppcp.detection.expression")) {
            SolverDetectorFactory.expressionDetector(this.model, this).applyThenCommit();
        }
        if (this.configuration.readBoolean("ppcp.detection.cliques")) {
            boolean symBreak = this.configuration.readBoolean("ppcp.detection.cliques.symetrieBreaking");
            ModelDetectorFactory.cliqueDetector(this.model, symBreak).applyThenCommit();
        }
        if (this.configuration.readBoolean("ppcp.detection.scheduling.cumulative.disjunctive")) {
            ModelDetectorFactory.disjFromCumulDetector(this.model).applyThenCommit();
        }
        if (this.configuration.readBoolean("ppcp.detection.scheduling.disjMod")) {
            AbstractDetector[] detectors;
            this.disjMod = new DisjunctiveModel(this.model);
            if (this.configuration.readBoolean("ppcp.detection.scheduling.disjMod.timeWindows")) {
                ModelDetectorFactory.precFromTimeWindowDetector(this.model, this.disjMod).applyThenCommit();
            }
            for (AbstractDetector det : detectors = ModelDetectorFactory.disjunctiveModelDetectors(this.model, this.disjMod, this.configuration.readBoolean("ppcp.detection.scheduling.disjMod.clauses"))) {
                det.applyThenCommit();
            }
            if (this.configuration.readBoolean("ppcp.detection.scheduling.disjMod.removeDisjunctive")) {
                ModelDetectorFactory.rmDisjDetector(this.model);
            }
        }
        this.mod2sol.readVariables(this.model);
        this.getMod2Sol().readBBDecisionVariables();
        this.getMod2Sol().readConstraints(this.model);
    }

    public boolean setVersatile(CPSolver s, int inittime) {
        return this.ppsearch.setVersatile(s, inittime);
    }

    public boolean setDomOverDeg(CPSolver s) {
        return this.ppsearch.setDomOverDeg(s);
    }

    public boolean setDomOverWeg(CPSolver s, int inittime) {
        return this.ppsearch.setDomOverWeg(s, inittime);
    }

    public boolean setImpact(CPSolver s, int initialisationtime) {
        return this.ppsearch.setImpact(s, initialisationtime);
    }

    boolean isScheduling() {
        if (this.model == null) {
            throw new SolverException("you must read the model before !");
        }
        return this.ppsearch.isScheduling();
    }

    public boolean isExtensionnal() {
        if (this.model == null) {
            throw new SolverException("you must read the model before !");
        }
        return this.model.getNbConstraintByType(ConstraintType.TABLE) > 0;
    }

    boolean isBinaryExtensionnal() {
        if (this.model == null) {
            throw new SolverException("you must read the model before !");
        }
        if (this.model.getNbConstraintByType(ConstraintType.TABLE) == 0) {
            return false;
        }
        Iterator<Constraint> it = this.model.getConstraintIterator();
        while (it.hasNext()) {
            Constraint ct = it.next();
            if (ct.getNbVars() <= 2) continue;
            return false;
        }
        return true;
    }

    public PPSearch getBBSearch() {
        return this.ppsearch;
    }

    public final <MV extends Variable, SV extends Var> void setVar(MV v, SV sv) {
        this.mapvariables.put(v.getIndex(), sv);
    }

    public final <MC extends Constraint, SC extends SConstraint> void setCstr(MC c, SC sc) {
        this.mapconstraints.put(c.getIndex(), sc);
    }

    public final boolean contains(Constraint c) {
        return this.mapconstraints.containsKey(c.getIndex());
    }

    public boolean initialPropagation() {
        this.proptime = (int)System.currentTimeMillis();
        try {
            this.propagate();
        }
        catch (ContradictionException e) {
            return false;
        }
        this.proptime = (int)System.currentTimeMillis() - this.proptime;
        return true;
    }

    public boolean rootNodeSingleton(int timelimit) {
        boolean sched = this.isScheduling();
        int time = (int)System.currentTimeMillis();
        if (this.proptime <= 1500) {
            int nbvrem = 0;
            int nbvtried = 0;
            int threshold = 100;
            this.worldPush();
            for (int i = 0; i < this.getNbIntVars(); ++i) {
                IntDomainVar v = this.getIntVar(i);
                DisposableIntIterator it = v.getDomain().getIterator();
                if ((!sched || v.getDomainSize() != 2) && (sched || !v.hasEnumeratedDomain())) continue;
                while (it.hasNext()) {
                    int val = it.next();
                    ++nbvtried;
                    boolean cont = false;
                    this.worldPush();
                    try {
                        v.instantiate(val, null, true);
                        this.propagate();
                    }
                    catch (ContradictionException e) {
                        cont = true;
                    }
                    this.worldPop();
                    if (cont) {
                        try {
                            ++nbvrem;
                            v.remVal(val);
                            this.propagate();
                        }
                        catch (ContradictionException e) {
                            return false;
                        }
                    }
                    if ((int)(System.currentTimeMillis() - (long)time) <= timelimit && (nbvtried != 100 || nbvrem != 0 || this.proptime < 200)) continue;
                    break;
                }
                it.dispose();
            }
        }
        return true;
    }
}

