/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.goals.GoalType;
import choco.kernel.solver.goals.solver.ChoicePoint;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.AbstractSearchLoop;
import java.util.ArrayList;
import java.util.List;

public class GoalSearchLoop
extends AbstractSearchLoop {
    protected final Goal mainGoal;
    private int previousNbSolutions;
    protected ChoicePoint currentChoice;
    protected List<Goal> currentGoalStack;
    protected int currentChoiceIndex;
    protected List<GoalTrace> goalTraceStack;
    protected boolean globalContradiction = false;
    private int node_count;

    public GoalSearchLoop(AbstractGlobalSearchStrategy searchStrategy, Goal mainGoal) {
        super(searchStrategy);
        this.mainGoal = mainGoal;
    }

    public void setGlobalContradiction() {
        this.globalContradiction = true;
    }

    @Override
    public void initLoop() {
        this.previousNbSolutions = this.searchStrategy.getSolutionCount();
        this.searchStrategy.setEncounteredLimit(null);
    }

    @Override
    public Boolean endLoop() {
        this.searchStrategy.limitManager.reset();
        if (this.searchStrategy.getSolutionCount() > this.previousNbSolutions) {
            return Boolean.TRUE;
        }
        if (this.searchStrategy.isEncounteredLimit()) {
            return null;
        }
        return Boolean.FALSE;
    }

    @Override
    public void initialize() {
        this.previousNbSolutions = 0;
        super.initialize();
    }

    @Override
    public final int getNodeCount() {
        return this.node_count;
    }

    public Goal popGoal() {
        int l = this.currentGoalStack.size();
        if (l == 0) {
            return null;
        }
        Goal g = this.currentGoalStack.get(l - 1);
        this.currentGoalStack.remove(l - 1);
        return g;
    }

    public void pushGoal(Goal g) {
        this.currentGoalStack.add(g);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void openNode() {
        try {
            block10: while (this.currentChoice == null && !this.stop) {
                Goal g = this.popGoal();
                if (g == null) {
                    this.searchStrategy.recordSolution();
                    this.searchStrategy.nextMove = 2;
                    this.stop = true;
                    continue;
                }
                GoalType gt = g.getType();
                switch (gt) {
                    case CHOICE: {
                        this.currentChoice = (ChoicePoint)g;
                        this.currentChoiceIndex = 0;
                        this.searchStrategy.pushTrace();
                        this.searchStrategy.nextMove = 4;
                        continue block10;
                    }
                    case GEN: {
                        ++this.node_count;
                        this.searchStrategy.limitManager.newNode();
                        break;
                    }
                }
                Goal newG = g.execute(this.searchStrategy.solver);
                switch (gt) {
                    case SET: 
                    case REM: {
                        this.searchStrategy.solver.propagate();
                        break;
                    }
                    case GEN: 
                    case INST: {
                        if (newG == null) break;
                        this.pushGoal(newG);
                        continue block10;
                    }
                }
            }
            return;
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = 2;
        }
    }

    public void popGoalTrace() {
        int l = this.goalTraceStack.size();
        if (l == 0) {
            this.currentGoalStack = null;
            this.currentChoice = null;
            this.currentChoiceIndex = -1;
        } else {
            GoalTrace trace = this.goalTraceStack.remove(l - 1);
            this.currentGoalStack = trace.goalStack;
            this.currentChoice = trace.choicePoint;
            this.currentChoiceIndex = trace.choiceIndex;
        }
    }

    @Override
    public void upBranch() {
        this.popGoalTrace();
        if (this.currentChoice == null) {
            this.stop = true;
        } else {
            if (this.globalContradiction) {
                this.searchStrategy.nextMove = 2;
            }
            try {
                this.searchStrategy.solver.worldPop();
                this.searchStrategy.limitManager.endNode();
                this.searchStrategy.postDynamicCut();
                ++this.currentChoiceIndex;
                if (this.currentChoiceIndex < this.currentChoice.getNbChoices()) {
                    this.searchStrategy.nextMove = 4;
                } else {
                    this.searchStrategy.popTrace();
                    this.searchStrategy.nextMove = 2;
                }
            }
            catch (ContradictionException e) {
                this.searchStrategy.popTrace();
                this.searchStrategy.nextMove = e.getContradictionMove();
            }
        }
    }

    public void pushGoalTrace() {
        GoalTrace trace = new GoalTrace(this.currentChoice, this.currentGoalStack, this.currentChoiceIndex);
        this.goalTraceStack.add(trace);
        ArrayList<Goal> l2 = new ArrayList<Goal>();
        l2.addAll(this.currentGoalStack);
        this.currentChoice = null;
        this.currentChoiceIndex = -1;
        this.currentGoalStack = l2;
    }

    @Override
    public void downBranch() {
        this.searchStrategy.solver.worldPush();
        Goal g = this.currentChoice.getChoice(this.currentChoiceIndex);
        this.pushGoalTrace();
        this.pushGoal(g);
        this.searchStrategy.nextMove = 1;
    }

    @Override
    public void restart() {
    }

    @Override
    public void initSearch() {
        this.searchStrategy.nextMove = 1;
        this.currentGoalStack = new ArrayList<Goal>();
        this.currentGoalStack.add(this.mainGoal);
        this.goalTraceStack = new ArrayList<GoalTrace>();
    }

    private static class GoalTrace {
        final ChoicePoint choicePoint;
        int choiceIndex;
        final List<Goal> goalStack;

        GoalTrace(ChoicePoint choicePoint, List<Goal> goalStack, int choiceIndex) {
            this.goalStack = goalStack;
            this.choicePoint = choicePoint;
            this.choiceIndex = choiceIndex;
        }
    }
}

