/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import moa.evaluation.MeasureCollection;

public abstract class AbstractGraphPlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected MeasureCollection[] measures;
    protected MeasureCollection[] measureStds;
    protected int measureSelected = 0;
    protected double min_x_value = 0.0;
    protected double max_x_value = 1.0;
    protected double max_y_value = 1.0;
    protected double lower_x_value = 0.0;
    protected double upper_x_value = 1.0;
    protected double upper_y_value = 1.0;
    protected double x_resolution;
    protected Color[] colors;
    protected boolean isStandardDeviationPainted = false;

    public AbstractGraphPlot() {
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1000, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    protected void setGraph(MeasureCollection[] measures, MeasureCollection[] stds, Color[] colors) {
        this.measures = measures;
        this.measureStds = stds;
        this.colors = colors;
        this.repaint();
    }

    public void setMeasureSelected(int selected) {
        this.measureSelected = selected;
    }

    protected void setMinXValue(double min) {
        this.min_x_value = min;
    }

    protected void setMaxXValue(double max) {
        this.max_x_value = max;
    }

    protected void setMaxYValue(double max) {
        this.max_y_value = max;
    }

    protected void setLowerXValue(double value) {
        this.lower_x_value = value;
    }

    protected void setUpperXValue(double value) {
        this.upper_x_value = value;
    }

    protected void setUpperYValue(double value) {
        this.upper_y_value = value;
    }

    protected void setXResolution(double x_resolution) {
        this.x_resolution = x_resolution;
    }

    protected void setStandardDeviationPainted(boolean b) {
        this.isStandardDeviationPainted = b;
    }

    protected void paintStandardDeviation(Graphics g, int len, int x, int y) {
        g.drawLine(x, y - len, x, y + len);
        g.drawLine(x - 5, y - len, x + 5, y - len);
        g.drawLine(x - 5, y + len, x + 5, y + len);
    }
}

