/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardPrioritization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParentsFirstShardPrioritization
implements ShardPrioritization {
    private static final SortingNode PROCESSING_NODE = new SortingNode(null, Integer.MIN_VALUE);
    private final int maxDepth;

    public ParentsFirstShardPrioritization(int maxDepth) {
        if (maxDepth <= 0) {
            throw new IllegalArgumentException("Max depth cannot be negative or zero. Provided value: " + maxDepth);
        }
        this.maxDepth = maxDepth;
    }

    @Override
    public List<ShardInfo> prioritize(List<ShardInfo> original) {
        HashMap<String, ShardInfo> shards = new HashMap<String, ShardInfo>();
        for (ShardInfo shardInfo : original) {
            shards.put(shardInfo.getShardId(), shardInfo);
        }
        HashMap<String, SortingNode> processedNodes = new HashMap<String, SortingNode>();
        for (ShardInfo shardInfo : original) {
            this.populateDepth(shardInfo.getShardId(), shards, processedNodes);
        }
        ArrayList<ShardInfo> arrayList = new ArrayList<ShardInfo>(original.size());
        ArrayList orderedNodes = new ArrayList(processedNodes.values());
        Collections.sort(orderedNodes);
        for (SortingNode sortingTreeNode : orderedNodes) {
            if (sortingTreeNode.getDepth() > this.maxDepth) continue;
            arrayList.add(sortingTreeNode.shardInfo);
        }
        return arrayList;
    }

    private int populateDepth(String shardId, Map<String, ShardInfo> shards, Map<String, SortingNode> processedNodes) {
        SortingNode processed = processedNodes.get(shardId);
        if (processed != null) {
            if (processed == PROCESSING_NODE) {
                throw new IllegalArgumentException("Circular dependency detected. Shard Id " + shardId + " is processed twice");
            }
            return processed.getDepth();
        }
        ShardInfo shardInfo = shards.get(shardId);
        if (shardInfo == null) {
            return 0;
        }
        if (shardInfo.isCompleted()) {
            return 0;
        }
        processedNodes.put(shardId, PROCESSING_NODE);
        int maxParentDepth = 0;
        for (String parentId : shardInfo.getParentShardIds()) {
            maxParentDepth = Math.max(maxParentDepth, this.populateDepth(parentId, shards, processedNodes));
        }
        int currentNodeLevel = maxParentDepth + 1;
        SortingNode previousValue = processedNodes.put(shardId, new SortingNode(shardInfo, currentNodeLevel));
        if (previousValue != PROCESSING_NODE) {
            throw new IllegalStateException("Validation failed. Depth for shardId " + shardId + " was populated twice");
        }
        return currentNodeLevel;
    }

    private static class SortingNode
    implements Comparable<SortingNode> {
        private final ShardInfo shardInfo;
        private final int depth;

        public SortingNode(ShardInfo shardInfo, int depth) {
            this.shardInfo = shardInfo;
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        @Override
        public int compareTo(SortingNode o) {
            return Integer.compare(this.depth, o.depth);
        }
    }
}

