/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.Clade;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.treemetrics.RootedTreeMetric;
import jebl.evolution.trees.RootedTree;

public class CladeMetric
implements RootedTreeMetric {
    BitSet tmpBits = new BitSet();
    private final Map<Taxon, Integer> taxonMap;

    public CladeMetric() {
        this.taxonMap = null;
    }

    public CladeMetric(List<Taxon> list) {
        this.taxonMap = new HashMap<Taxon, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            this.taxonMap.put(list.get(i), i);
        }
    }

    @Override
    public double getMetric(RootedTree rootedTree, RootedTree rootedTree2) {
        Object object;
        Map<Taxon, Integer> map = this.taxonMap;
        if (map == null) {
            object = new ArrayList<Taxon>(rootedTree2.getTaxa());
            if (!rootedTree2.getTaxa().equals(object)) {
                map = new HashMap<Taxon, Integer>();
            }
            for (int i = 0; i < object.size(); ++i) {
                map.put((Taxon)object.get(i), i);
            }
        }
        object = this.getClade(map, rootedTree, rootedTree.getRootNode(), null);
        ArrayList<Clade> arrayList = new ArrayList<Clade>();
        this.getClades(map, rootedTree2, rootedTree2.getRootNode(), arrayList, null);
        if (this.contains(arrayList, (Clade)object)) {
            return 1.0;
        }
        return 0.0;
    }

    private void getClades(Map<Taxon, Integer> map, RootedTree rootedTree, Node node, List<Clade> list, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        if (rootedTree.isExternal(node)) {
            int n = map.get(rootedTree.getTaxon(node));
            bitSet2.set(n);
        } else {
            for (Node node2 : rootedTree.getChildren(node)) {
                this.getClades(map, rootedTree, node2, list, bitSet2);
            }
            list.add(new Clade(bitSet2, rootedTree.getHeight(node)));
        }
        if (bitSet != null) {
            bitSet.or(bitSet2);
        }
    }

    private Clade getClade(Map<Taxon, Integer> map, RootedTree rootedTree, Node node, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        Clade clade = null;
        if (rootedTree.isExternal(node)) {
            int n = map.get(rootedTree.getTaxon(node));
            bitSet2.set(n);
        } else {
            for (Node node2 : rootedTree.getChildren(node)) {
                this.getClade(map, rootedTree, node2, bitSet2);
            }
            clade = new Clade(bitSet2, rootedTree.getHeight(node));
        }
        if (bitSet != null) {
            bitSet.or(bitSet2);
        }
        return clade;
    }

    private boolean contains(List<Clade> list, Clade clade) {
        for (Clade clade2 : list) {
            if (!clade.equals(clade2)) continue;
            return true;
        }
        return false;
    }
}

