/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evomodel.alloppnet.speciation.BirthDeathCollapseModel;
import dr.evomodel.alloppnet.speciation.BirthDeathCollapseNClustersStatistic;
import dr.evomodel.speciation.SpeciesTreeModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class BirthDeathCollapseNClustersStatisticParser
extends AbstractXMLObjectParser {
    public static final String BDC_NCLUSTERS_STATISTIC = "bdcNClustersStatistic";
    public static final String SPECIES_TREE = "speciesTree";
    public static final String COLLAPSE_MODEL = "collapseModel";

    @Override
    public String getParserName() {
        return BDC_NCLUSTERS_STATISTIC;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        xMLObject.getAttribute("name");
        XMLObject xMLObject2 = xMLObject.getChild(SPECIES_TREE);
        SpeciesTreeModel speciesTreeModel = (SpeciesTreeModel)xMLObject2.getChild(SpeciesTreeModel.class);
        XMLObject xMLObject3 = xMLObject.getChild(COLLAPSE_MODEL);
        BirthDeathCollapseModel birthDeathCollapseModel = (BirthDeathCollapseModel)xMLObject3.getChild(BirthDeathCollapseModel.class);
        return new BirthDeathCollapseNClustersStatistic(speciesTreeModel, birthDeathCollapseModel);
    }

    private XMLSyntaxRule[] spptreeRules() {
        return new XMLSyntaxRule[]{new ElementRule(SpeciesTreeModel.class)};
    }

    private XMLSyntaxRule[] bdcmRules() {
        return new XMLSyntaxRule[]{new ElementRule(BirthDeathCollapseModel.class)};
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newStringRule("name"), new ElementRule(SPECIES_TREE, this.spptreeRules()), new ElementRule(COLLAPSE_MODEL, this.bdcmRules())};
    }

    @Override
    public String getParserDescription() {
        return "Statistic for number of collapsed nodes in species tree when using birth-death-collapse model.";
    }

    @Override
    public Class getReturnType() {
        return BirthDeathCollapseNClustersStatistic.class;
    }
}

