/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions.gp;

import dr.inference.model.DesignMatrix;
import dr.inference.model.Parameter;
import dr.math.distributions.gp.AdditiveGaussianProcessDistribution;
import dr.math.distributions.gp.GaussianProcessKernel;
import dr.math.distributions.gp.GaussianProcessPrediction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GaussianProcessConditionalDerivative
extends GaussianProcessPrediction {
    private final Parameter realizedValues;
    private final int dim;
    private final Parameter priorMeanDerivative;

    public GaussianProcessConditionalDerivative(AdditiveGaussianProcessDistribution additiveGaussianProcessDistribution, Parameter parameter, Parameter parameter2) {
        super(additiveGaussianProcessDistribution, parameter, GaussianProcessConditionalDerivative.extractDesignMatrices(additiveGaussianProcessDistribution));
        gp = additiveGaussianProcessDistribution;
        this.dim = parameter.getDimension();
        this.priorMeanDerivative = parameter2;
        this.realizedValues = parameter;
        this.mean = new double[this.dim];
        parameter2.addVariableListener(this);
    }

    public GaussianProcessConditionalDerivative(AdditiveGaussianProcessDistribution additiveGaussianProcessDistribution, Parameter parameter) {
        this(additiveGaussianProcessDistribution, parameter, GaussianProcessConditionalDerivative.setDefaultPriorMean(parameter.getDimension()));
    }

    private static Parameter setDefaultPriorMean(int n) {
        Parameter parameter = null;
        for (int i = 0; i < n; ++i) {
            parameter.setParameterValue(i, 0.0);
        }
        return parameter;
    }

    private static List<DesignMatrix> extractDesignMatrices(AdditiveGaussianProcessDistribution additiveGaussianProcessDistribution) {
        ArrayList<DesignMatrix> arrayList = new ArrayList<DesignMatrix>();
        for (AdditiveGaussianProcessDistribution.BasisDimension basisDimension : additiveGaussianProcessDistribution.getBases()) {
            arrayList.add(basisDimension.getDesignMatrix1());
        }
        return arrayList;
    }

    @Override
    protected List<AdditiveGaussianProcessDistribution.BasisDimension> makeBases(boolean bl) {
        ArrayList<AdditiveGaussianProcessDistribution.BasisDimension> arrayList = new ArrayList<AdditiveGaussianProcessDistribution.BasisDimension>();
        List<AdditiveGaussianProcessDistribution.BasisDimension> list = gp.getBases();
        for (int i = 0; i < list.size(); ++i) {
            AdditiveGaussianProcessDistribution.BasisDimension basisDimension = list.get(i);
            GaussianProcessKernel gaussianProcessKernel = basisDimension.getKernel();
            DesignMatrix designMatrix = basisDimension.getDesignMatrix1();
            GaussianProcessKernel.KernelDerivatives kernelDerivatives = new GaussianProcessKernel.KernelDerivatives(gaussianProcessKernel, bl);
            AdditiveGaussianProcessDistribution.BasisDimension basisDimension2 = new AdditiveGaussianProcessDistribution.BasisDimension(kernelDerivatives, designMatrix, designMatrix);
            arrayList.add(basisDimension2);
        }
        return arrayList;
    }

    @Override
    protected void computeMean() {
        if (!this.meanKnown) {
            this.computeCrossRealized();
            double[] dArray = gp.getMean();
            this.mean = Arrays.copyOf(this.priorMeanDerivative.getParameterValues(), this.priorMeanDerivative.getDimension());
            for (int i = 0; i < this.dim; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    int n = i;
                    this.mean[n] = this.mean[n] + this.crossRealized.get(i, j) * (this.realizedValues.getParameterValue(j) - dArray[j]);
                }
            }
            this.meanKnown = true;
        }
    }

    @Override
    protected void computeCholesky() {
        if (!this.solver.setA(this.variance)) {
            for (int i = 0; i < this.dim; ++i) {
                double d = gp.getNugget(0);
                this.variance.add(i, i, d);
            }
            if (!this.solver.setA(this.variance)) {
                throw new RuntimeException("Unable to decompose matrix");
            }
        }
    }
}

