/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Matrix
extends Iterable<MatrixEntry> {
    public int numRows();

    public int numColumns();

    public boolean isSquare();

    public void set(int var1, int var2, double var3);

    public void add(int var1, int var2, double var3);

    public double get(int var1, int var2);

    public Matrix copy();

    public Matrix zero();

    public Vector mult(Vector var1, Vector var2);

    public Vector mult(double var1, Vector var3, Vector var4);

    public Vector multAdd(Vector var1, Vector var2);

    public Vector multAdd(double var1, Vector var3, Vector var4);

    public Vector transMult(Vector var1, Vector var2);

    public Vector transMult(double var1, Vector var3, Vector var4);

    public Vector transMultAdd(Vector var1, Vector var2);

    public Vector transMultAdd(double var1, Vector var3, Vector var4);

    public Vector solve(Vector var1, Vector var2) throws MatrixSingularException, MatrixNotSPDException;

    public Vector transSolve(Vector var1, Vector var2) throws MatrixSingularException, MatrixNotSPDException;

    public Matrix rank1(Vector var1);

    public Matrix rank1(double var1, Vector var3);

    public Matrix rank1(Vector var1, Vector var2);

    public Matrix rank1(double var1, Vector var3, Vector var4);

    public Matrix rank2(Vector var1, Vector var2);

    public Matrix rank2(double var1, Vector var3, Vector var4);

    public Matrix mult(Matrix var1, Matrix var2);

    public Matrix mult(double var1, Matrix var3, Matrix var4);

    public Matrix multAdd(Matrix var1, Matrix var2);

    public Matrix multAdd(double var1, Matrix var3, Matrix var4);

    public Matrix transAmult(Matrix var1, Matrix var2);

    public Matrix transAmult(double var1, Matrix var3, Matrix var4);

    public Matrix transAmultAdd(Matrix var1, Matrix var2);

    public Matrix transAmultAdd(double var1, Matrix var3, Matrix var4);

    public Matrix transBmult(Matrix var1, Matrix var2);

    public Matrix transBmult(double var1, Matrix var3, Matrix var4);

    public Matrix transBmultAdd(Matrix var1, Matrix var2);

    public Matrix transBmultAdd(double var1, Matrix var3, Matrix var4);

    public Matrix transABmult(Matrix var1, Matrix var2);

    public Matrix transABmult(double var1, Matrix var3, Matrix var4);

    public Matrix transABmultAdd(Matrix var1, Matrix var2);

    public Matrix transABmultAdd(double var1, Matrix var3, Matrix var4);

    public Matrix solve(Matrix var1, Matrix var2) throws MatrixSingularException, MatrixNotSPDException;

    public Matrix transSolve(Matrix var1, Matrix var2) throws MatrixSingularException, MatrixNotSPDException;

    public Matrix rank1(Matrix var1);

    public Matrix rank1(double var1, Matrix var3);

    public Matrix transRank1(Matrix var1);

    public Matrix transRank1(double var1, Matrix var3);

    public Matrix rank2(Matrix var1, Matrix var2);

    public Matrix rank2(double var1, Matrix var3, Matrix var4);

    public Matrix transRank2(Matrix var1, Matrix var2);

    public Matrix transRank2(double var1, Matrix var3, Matrix var4);

    public Matrix scale(double var1);

    public Matrix set(Matrix var1);

    public Matrix set(double var1, Matrix var3);

    public Matrix add(Matrix var1);

    public Matrix add(double var1, Matrix var3);

    public Matrix transpose();

    public Matrix transpose(Matrix var1);

    public double norm(Norm var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Norm {
        One,
        Frobenius,
        Infinity,
        Maxvalue;

    }
}

