/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.trees.HoeffdingOptionTree;
import weka.core.Instance;
import weka.core.Utils;

public class AdaHoeffdingOptionTree
extends HoeffdingOptionTree {
    private static final long serialVersionUID = 1L;

    public String getPurposeString() {
        return "Adaptive decision option tree for streaming data with adaptive Naive Bayes classification at leaves.";
    }

    protected HoeffdingOptionTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new AdaLearningNode(initialClassObservations);
    }

    public static class AdaLearningNode
    extends HoeffdingOptionTree.LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;
        protected double CorrectWeight = 0.0;
        protected double alpha = 0.2;

        public AdaLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingOptionTree hot) {
            int trueClass = (int)inst.classValue();
            boolean blCorrect = false;
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
                if (this.mcCorrectWeight > this.nbCorrectWeight) {
                    blCorrect = true;
                }
            }
            if (Utils.maxIndex(NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
                if (this.mcCorrectWeight <= this.nbCorrectWeight) {
                    blCorrect = true;
                }
            }
            this.CorrectWeight = blCorrect ? (this.CorrectWeight += this.alpha * (1.0 - this.CorrectWeight)) : (this.CorrectWeight -= this.alpha * this.CorrectWeight);
            super.learnFromInstance(inst, hot);
        }

        public double[] getClassVotes(Instance inst, HoeffdingOptionTree ht) {
            double[] dist = this.mcCorrectWeight > this.nbCorrectWeight ? this.observedClassDistribution.getArrayCopy() : NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            double distSum = Utils.sum(dist);
            if (distSum * (1.0 - this.CorrectWeight) * (1.0 - this.CorrectWeight) > 0.0) {
                Utils.normalize(dist, distSum * (1.0 - this.CorrectWeight) * (1.0 - this.CorrectWeight));
            }
            return dist;
        }
    }
}

