## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("r_times")

head(r_times, n = 30)

## -----------------------------------------------------------------------------
trial_duration <- max(r_times) |> ceiling() # To take the immediate superior integer.

optim_times <- ind_trials_opt(r_times, trial_duration) # Note we used the default optimization method.

optim_times

## -----------------------------------------------------------------------------
exhaus_times <- exhaustive_lhl(r_times, trial_duration)

exhaus_times

## ----echo=FALSE---------------------------------------------------------------
plot(
  density(
    r_times,
    adjust = 0.8,
    from = 0,
    to = trial_duration
  ),
  main = "Density plot of response times",
  xlab = "Response time (ms)",
  ylab = expression(italic(p(t[R]))),
)
abline(v = 60, lty = 2)
abline(v = optim_times$start, col = "red")
abline(v = optim_times$stop, col = "red")
abline(v = optim_times$middle, col = "red")

