/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate.tests;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.BCubedEvaluator;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;
import cc.mallet.cluster.evaluate.MUCEvaluator;
import cc.mallet.cluster.evaluate.PairF1Evaluator;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestClusteringEvaluators
extends TestCase {
    public TestClusteringEvaluators(String name) {
        super(name);
    }

    private Clustering generateTruth(InstanceList instances) {
        int[] labels = new int[]{0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2};
        return new Clustering(instances, 3, labels);
    }

    private Clustering[] generatePredicted(InstanceList instances) {
        Clustering[] clusterings = new Clustering[]{new Clustering(instances, 2, new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1}), new Clustering(instances, 2, new int[]{0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}), new Clustering(instances, 1, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), new Clustering(instances, 12, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11})};
        return clusterings;
    }

    public void testEvaluators() {
        InstanceList instances = new InstanceList(new Randoms(1), 100, 2).subList(0, 12);
        System.err.println(instances.size() + " instances");
        Clustering truth = this.generateTruth(instances);
        System.err.println("truth=" + truth);
        Clustering[] predicted = this.generatePredicted(instances);
        PairF1Evaluator pweval = new PairF1Evaluator();
        BCubedEvaluator bceval = new BCubedEvaluator();
        MUCEvaluator muceval = new MUCEvaluator();
        for (int i = 0; i < predicted.length; ++i) {
            System.err.println("\npred" + i + "=" + predicted[i]);
            System.err.println("pairs: " + ((ClusteringEvaluator)pweval).evaluate(truth, predicted[i]));
            System.err.println("bcube: " + ((ClusteringEvaluator)bceval).evaluate(truth, predicted[i]));
            System.err.println("  muc: " + ((ClusteringEvaluator)muceval).evaluate(truth, predicted[i]));
        }
        System.err.println("totals:");
        System.err.println("pairs: " + ((ClusteringEvaluator)pweval).evaluateTotals());
        System.err.println("bcube: " + ((ClusteringEvaluator)bceval).evaluateTotals());
        System.err.println("  muc: " + ((ClusteringEvaluator)muceval).evaluateTotals());
        TestClusteringEvaluators.assertTrue(((ClusteringEvaluator)pweval).evaluateTotals().matches(".*f1=0\\.5550.*"));
        TestClusteringEvaluators.assertTrue(((ClusteringEvaluator)bceval).evaluateTotals().matches(".*f1=0\\.7404.*"));
        TestClusteringEvaluators.assertTrue(((ClusteringEvaluator)muceval).evaluateTotals().matches(".*f1=0\\.8059.*"));
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestClusteringEvaluators.class);
    }

    @Override
    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run(TestClusteringEvaluators.suite());
    }
}

