/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.comparator;

import choco.kernel.common.util.comparator.EarliestCompletionTimeCmp;
import choco.kernel.common.util.comparator.EarliestStartingTimeCmp;
import choco.kernel.common.util.comparator.LatestCompletionTimeCmp;
import choco.kernel.common.util.comparator.LatestStartingTimeCmp;
import choco.kernel.common.util.comparator.MinDurationCmp;
import choco.kernel.common.util.comparator.TaskComparatorWrapper;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.Collections;
import java.util.Comparator;

public final class TaskComparators {
    private static final Comparator<IRTask> RT_EST = new TaskComparatorWrapper(TaskComparators.makeEarliestStartingTimeCmp());
    private static final Comparator<IRTask> RT_ECT = new TaskComparatorWrapper(TaskComparators.makeEarliestCompletionTimeCmp());
    private static final Comparator<IRTask> RT_LST = new TaskComparatorWrapper(TaskComparators.makeLatestStartingTimeCmp());
    private static final Comparator<IRTask> RT_LCT = new TaskComparatorWrapper(TaskComparators.makeLatestCompletionTimeCmp());
    private static final Comparator<IRTask> REV_RT_EST = Collections.reverseOrder(RT_EST);
    private static final Comparator<IRTask> REV_RT_ECT = Collections.reverseOrder(RT_ECT);
    private static final Comparator<IRTask> REV_RT_LST = Collections.reverseOrder(RT_LST);
    private static final Comparator<IRTask> REV_RT_LCT = Collections.reverseOrder(RT_LCT);

    private TaskComparators() {
    }

    public static Comparator<ITask> makeLatestCompletionTimeCmp() {
        return LatestCompletionTimeCmp.SINGLETON;
    }

    public static Comparator<ITask> makeEarliestCompletionTimeCmp() {
        return EarliestCompletionTimeCmp.SINGLETON;
    }

    public static Comparator<ITask> makeLatestStartingTimeCmp() {
        return LatestStartingTimeCmp.SINGLETON;
    }

    public static Comparator<ITask> makeEarliestStartingTimeCmp() {
        return EarliestStartingTimeCmp.SINGLETON;
    }

    public static Comparator<ITask> makeReverseEarliestCompletionTimeCmp() {
        return EarliestCompletionTimeCmp.RSINGLETON;
    }

    public static Comparator<ITask> makeReverseLatestStartingTimeCmp() {
        return LatestStartingTimeCmp.RSINGLETON;
    }

    public static Comparator<ITask> makeReverseLatestCompletionTimeCmp() {
        return LatestCompletionTimeCmp.RSINGLETON;
    }

    public static Comparator<ITask> makeReverseEarliestStartingTimeCmp() {
        return EarliestStartingTimeCmp.RSINGLETON;
    }

    public static Comparator<ITask> makeMinDurationCmp() {
        return MinDurationCmp.SINGLETON;
    }

    public static Comparator<ITask> makeRMinDurationCmp() {
        return MinDurationCmp.RSINGLETON;
    }

    public static Comparator<IRTask> makeRLatestCompletionTimeCmp() {
        return RT_LCT;
    }

    public static Comparator<IRTask> makeREarliestCompletionTimeCmp() {
        return RT_ECT;
    }

    public static Comparator<IRTask> makeRLatestStartingTimeCmp() {
        return RT_LST;
    }

    public static Comparator<IRTask> makeREarliestStartingTimeCmp() {
        return RT_EST;
    }

    public static Comparator<IRTask> makeReverseREarliestCompletionTimeCmp() {
        return REV_RT_ECT;
    }

    public static Comparator<IRTask> makeReverseRLatestStartingTimeCmp() {
        return REV_RT_LST;
    }

    public static Comparator<IRTask> makeReverseRLatestCompletionTimeCmp() {
        return REV_RT_LCT;
    }

    public static Comparator<IRTask> makeReverseREarliestStartingTimeCmp() {
        return REV_RT_EST;
    }
}

