/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RPair;

public class RDoubleVector
extends RNumberVector<Double> {
    private double[] values = null;
    public static final RDoubleVector EMPTY = new RDoubleVector(new double[0], null);

    public RDoubleVector(Number value, RPair attributes) {
        this(Collections.singletonList(value), attributes);
    }

    public RDoubleVector(List<Number> values, RPair attributes) {
        super(attributes);
        this.values = values.stream().mapToDouble(value -> {
            if (value == null) {
                return Double.NaN;
            }
            return value.doubleValue();
        }).toArray();
    }

    public RDoubleVector(double[] values, RPair attributes) {
        super(attributes);
        this.values = values;
    }

    @Override
    int type() {
        return 14;
    }

    @Override
    void writeValues(RDataOutput output) throws IOException {
        double[] values = this.values;
        int length = values.length;
        output.writeInt(length);
        for (int i = 0; i < length; ++i) {
            output.writeDouble(values[i]);
        }
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Double getValue(int index) {
        return this.values[index];
    }

    @Override
    public List<Double> getValues() {
        return Doubles.asList((double[])this.values);
    }
}

