/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropEnumDomainChanneling
extends Propagator<IntVar> {
    private final int n;
    private final IntProcedure rem_proc;
    private final IIntDeltaMonitor idm;
    private final int offSet;

    public PropEnumDomainChanneling(BoolVar[] bvars, IntVar aVar, int offSet) {
        super((Variable[])ArrayUtils.concat((IntVar[])bvars, aVar), (Priority)PropagatorPriority.UNARY, true);
        assert (aVar.hasEnumeratedDomain());
        this.n = bvars.length;
        this.offSet = offSet;
        this.idm = ((IntVar[])this.vars)[this.n].monitorDelta(this);
        this.rem_proc = i -> ((IntVar[])this.vars)[i - offSet].instantiateTo(0, (ICause)this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateBounds(this.offSet, this.n - 1 + this.offSet, this);
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                if (((IntVar[])this.vars)[i].getValue() == 0) {
                    ((IntVar[])this.vars)[this.n].removeValue(i + this.offSet, (ICause)this);
                    continue;
                }
                ((IntVar[])this.vars)[this.n].instantiateTo(i + this.offSet, (ICause)this);
                continue;
            }
            if (((IntVar[])this.vars)[this.n].contains(i + this.offSet)) continue;
            ((IntVar[])this.vars)[i].instantiateTo(0, (ICause)this);
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            int v = ((IntVar[])this.vars)[this.n].getValue() - this.offSet;
            ((IntVar[])this.vars)[v].instantiateTo(1, (ICause)this);
            for (int i = 0; i < this.n; ++i) {
                if (i == v) continue;
                ((IntVar[])this.vars)[i].instantiateTo(0, (ICause)this);
            }
        }
        this.idm.startMonitoring();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx == this.n) {
            this.idm.forEachRemVal(this.rem_proc);
        } else if (((IntVar[])this.vars)[varIdx].getValue() == 1) {
            ((IntVar[])this.vars)[this.n].instantiateTo(varIdx + this.offSet, (ICause)this);
            for (int i = 0; i < this.n; ++i) {
                if (i == varIdx) continue;
                ((IntVar[])this.vars)[i].instantiateTo(0, (ICause)this);
            }
        } else {
            ((IntVar[])this.vars)[this.n].removeValue(varIdx + this.offSet, (ICause)this);
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            ((IntVar[])this.vars)[((IntVar[])this.vars)[this.n].getValue() - this.offSet].instantiateTo(1, (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        int v;
        if (((IntVar[])this.vars)[this.n].getLB() > this.n - 1 + this.offSet || ((IntVar[])this.vars)[this.n].getUB() < this.offSet) {
            return ESat.FALSE;
        }
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated() || ((IntVar[])this.vars)[i].getValue() != 1 || ((IntVar[])this.vars)[this.n].contains(i + this.offSet)) continue;
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated() && !((IntVar[])this.vars)[v = ((IntVar[])this.vars)[this.n].getValue() - this.offSet].contains(1)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

