/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.Arrays;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.RealValueSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;

public class RealStrategy
extends AbstractStrategy<RealVar> {
    private final VariableSelector<RealVar> varselector;
    private final RealValueSelector valueIterator;
    private final double epsilon;
    private final boolean leftFirst;

    public RealStrategy(RealVar[] scope, VariableSelector<RealVar> varselector, RealValueSelector valueIterator, double epsilon, boolean leftFirst) {
        super((Variable[])scope);
        this.varselector = varselector;
        this.valueIterator = valueIterator;
        if (Double.isNaN(epsilon)) {
            double min = Arrays.stream(scope).mapToDouble(RealVar::getPrecision).min().getAsDouble();
            this.epsilon = min / 10.0;
        } else {
            this.epsilon = epsilon;
        }
        this.leftFirst = leftFirst;
    }

    @Override
    public boolean init() {
        return this.varselector.init();
    }

    @Override
    public void remove() {
        this.varselector.remove();
    }

    @Override
    public Decision<RealVar> computeDecision(RealVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        double value = this.valueIterator.selectValue(variable);
        return variable.getModel().getSolver().getDecisionPath().makeRealDecision(variable, value, this.epsilon, this.leftFirst);
    }

    @Override
    public Decision getDecision() {
        RealVar variable = (RealVar)this.varselector.getVariable((RealVar[])this.vars);
        return this.computeDecision(variable);
    }
}

