/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.grid.regular.square;

import org.flsgen.grid.Grid;

public class RegularSquareGrid
extends Grid {
    protected int nbRows;
    protected int nbCols;

    public RegularSquareGrid(int nbRows, int nbCols) {
        assert (nbCols > 0);
        assert (nbRows > 0);
        this.nbRows = nbRows;
        this.nbCols = nbCols;
    }

    @Override
    public int getNbCells() {
        return this.nbRows * this.nbCols;
    }

    public int getIndexFromCoordinates(int row, int col) {
        assert (row >= 0);
        assert (row < this.nbRows);
        assert (col >= 0);
        assert (col < this.nbCols);
        return this.getNbCols() * row + col;
    }

    public int[] getCoordinatesFromIndex(int index) {
        int row = Math.floorDiv(index, this.getNbCols());
        int col = index % this.getNbCols();
        return new int[]{row, col};
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public int getNbCols() {
        return this.nbCols;
    }

    @Override
    public double[][] getCartesianCoordinates() {
        double[][] coords = new double[this.getNbCells()][];
        for (int y = 0; y < this.getNbRows(); ++y) {
            for (int x = 0; x < this.getNbCols(); ++x) {
                coords[this.getIndexFromCoordinates((int)y, (int)x)] = new double[]{x, y};
            }
        }
        return coords;
    }

    @Override
    public double[] getCartesianCoordinates(int site) {
        int[] coords = this.getCoordinatesFromIndex(site);
        return new double[]{coords[0], coords[1]};
    }
}

