#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

#MCL (Multinomial Conditional Logit) - wielomianowy warunkowy model logitowy (zmienne objaniajce opisuj profile)
#Skrypt szacuje parametry warunkowego modelu logitowego metod najwikszej wiarygodnoci
#(logarytm funkcji jest maksymalizowany)
#Na podstawie: S. Jackman [2007] - Models for Unordered Outcomes, Political Science 150C/350C, Revision 134, April 30
#Dane: D. Jaskowski [2008]
source("fnw.r")
source("Pclm.r")
source("Prs.r")
options(OutDec=",")
dane<-read.csv2("stoki1.csv", header=TRUE)	#211 respondentw*9 profilw=1899 obserwacji
print(dane[1:10,])
attach(dane)
P<-9                    #liczba profilw
(n<-dim(dane)[1]/P)  	#liczba respondentw [n=211]
s<-rep(1:n, each=P)  	#identyfikator obserwacji (respondenta) [1:211, 9]
p<-rep(1:P, n)          #identyfikator profilu [1:9, 211]
wybrany<-profwyb==1     #TRUE, gdy respondent s wybra profil p, w przeciwnym razie FALSE
y<-p[wybrany]           #numery wybranych profilw
table(y)                #ile razy wybrany zosta kady profil
#kodowanie poziomw atrybutw (zero-jedynkowe)
print(options("contrasts"))
options(contrasts=c("contr.treatment","contr.poly"))
print(options("contrasts"))
#kodowanie zero-jedynkowe poziomw atrybutw (poziom odniesienia ostatni)
Z<-model.matrix(~relevel(factor(miejscowosc),ref="3")+relevel(factor(stok),ref="2")+relevel(factor(baza),ref="3")+relevel(factor(zaplecze),ref="3"),data=dane)
detach(dane)
M<-Z[,2:ncol(Z)]	#macierz X zawiera atrybuty (kodowane zero-jeden, bez wyrazu wolnego (M z wyrazem wolnym))
nazwy<-c("miejscowosc1","miejscowosc2","stok1","baza1","baza2","zaplecze1","zaplecze2")
colnames(M)<-nazwy
(k<-dim(M)[2]) 	#liczba atrybutw zero-jedynkowych
a<-rep(0,k)    	#wartoci startowe parametrw modelu
#estymacja warunkowego modelu logitowego
clm<-optim(par=a,fn=fnw,x=M,y=wybrany,control=list(trace=TRUE,fnscale=-1),method="BFGS",hessian=TRUE)
se<-sqrt(diag(solve(-clm$hessian)))   	#standardowe bdy parametrw
B<-clm$par						#parametry
wyniki<-cbind(B, se)	            	#parametry i bdy
wyniki<-cbind(wyniki,wyniki[,1]/wyniki[,2],exp(wyniki[,1]))		#parametry, bdy i statystyka Z (parametr/bd)
dimnames(wyniki)<-list(nazwy,c("Parametr","Bd standardowy","Statystyka Z","exp(Parametr)"))
print(signif(wyniki,4))
#prawdopodobiestwa wyboru profilw
Pr<-Pclm(B, M[1:P,])
Ps<-Prs(Pr)
colnames(Ps)<-c("Profil","Prawdopodobiestwo wyboru")
print("Prawdopodobiestwa wyboru profilw uporzdkowane malejco")
print(Ps)
sum(Ps[,2])
print("Wykres wanoci poziomw atrybutw")
windows(width=6, height=4, pointsize=7)
barplot(exp(B),ylab="exp(B)",xlab="atrybuty",ylim=c(0,4.0),names.arg=nazwy,las=1)
abline(h=1)