#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Marek Walesiak, Andrzej Dudek     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(kernlab)
library(mlbench)
library(clusterSim)
library(panel)
data(data_patternGDM2)
x<-data_patternGDM2
options(OutDec=",")
nc<-4  #(liczba klas ustalona metod Girolamiego)
dist<-dist.GDM(x,method="GDM2")
gdm<-as.matrix(dist)
#krok 4a - obliczenie sigmy
mod.sample<-0.75
bootstrap<-x[sample(1:nrow(x),nrow(x)*mod.sample),]
sigWithinss<--1
levelsPower=10.0;
levels<-3
lstart<-0
lend<-sum(gdm)
lby<-lend/levelsPower
for(ll in levels:1){
  lby<-lby/levelsPower
  sigmas<-(seq(lstart,lend-lby,by=lby)+seq(lstart+lby,lend,by=lby))/2
  i<-0
  for (sigma in sigmas) {
    oldsigma<-sigma
    ka<-exp(-as.matrix(dist.GDM(bootstrap,method="GDM2"))*sigma)
    d <- 1/sqrt(rowSums(ka))
    l <- d * ka %*% diag(d)
    xi<-NULL
    tf<-function(l,nc){eigen(l,symmetric=TRUE)$vectors[,1:nc]}
    xi <- try(tf(l,nc))
    if(class(tf)!="try-error"){
      if(!is.null(xi)  && is.numeric(xi)){
      yi <-try(xi/sqrt(rowSums(xi^2)))
      if(sum(is.na(yi))==0){
        iterations<-20
        res <- try(kmeans(yi, yi[initial.Centers(yi,nc),],iterations))
        if(class(res)=="try-error"){
          res<-list(withinss=1e10)
          next
        }
        if(sum(res$withinss)<sigWithinss || sigWithinss==-1){
          sig<-sigma
          sigWithinss<-sum(res$withinss)
        }
      }
      i<-i+1
      }
    }
  }
  if(oldsigma==sigma){
    ll<-0
  }
  lstart<-sig-0.5*lby
  lend<-sig+0.5*lby
}
print(paste("Optymalna sigma:" ,sig),quote=FALSE)
print(paste("Suma odlegoci wewntrzklasowych:",sigWithinss),quote=FALSE)

#krok 4b - obliczenie macierzy podobiestwa (affinity matrix)
km<-exp(-gdm*sig)

#krok 5a - obliczenie  macierzy diagonalnej wag
diag(km)<-0
d <- 1/sqrt(rowSums(km))

#krok 5b - obliczenie macierzy Laplace'a 
l <- d * km %*% diag(d)

#krok 6 - obliczenie wektorw wasnych dla macierzy Laplace'a (utworzenie macierzy E)
xi <- eigen(l)$vectors[, 1:nc]

#krok 7 - normalizacja macierzy E
yi <- xi/sqrt(rowSums(xi^2))

#krok 8 - waciwa klasyfikacja (metoda k-rednich) na podstawie macierzy Y
res <- kmeans(yi, yi[initial.Centers(yi, nc),], iterations)
clas1<-res$cluster

print("Prezentacja klasyfikacji wynikowej", quote=FALSE)
xx<-1:nrow(x)
dim(clas1)<-c(length(clas1),1)
cl_wyn1<-as.data.frame(clas1)
row.names(cl_wyn1)<-xx
colnames(cl_wyn1)<-"klasa"
print(cl_wyn1)

print("Prezentacja klasyfikacji wynikowej - uporzdkowana", quote=FALSE)
ord<-order(cl_wyn1[,"klasa"],decreasing=FALSE)
cl_wyn2 <- as.data.frame(cl_wyn1[ord,])
row.names(cl_wyn2)<-xx[ord]
colnames(cl_wyn2)<-"klasa"
print(cl_wyn2)

desc <-cluster.Description(x, clas1, "population")
print("Dominanty", quote=FALSE)
print(desc[,,5])