#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Eugeniusz Gatnar     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(tree)
options(OutDec=",")
german<-read.csv2(file="german_credit.csv")			# czytanie zbioru danych
set.seed(123)
m<-nrow(german)
test<-sample(1:m,size=round(m/3),replace=FALSE) 
german.test<-data.frame(german[test,])				# zbir uczcy
german.ucz<-data.frame(german[-test,])				# zbir testowy
drzewo.gcu<-tree(ocena~.,german.ucz)				# model dla zbioru uczcego
pred<-predict.tree(drzewo.gcu,german.test,type="class")
blad<-1-sum(pred==german.test$ocena)/nrow(german.test)
print("Bd klasyfikacji dla zbioru testowego:",quote=FALSE)
print(blad)